/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.web.login;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securitymanager.service.login.LoginService;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private LoginService loginService;

    @RequestMapping(value={"/v1/login/challenge"}, method={RequestMethod.GET})
    public Object getChallenge(HttpServletResponse resp) {
        try {
            return this.loginService.getChallenge();
        }
        catch (ServiceException e) {
            this.logger.error("\u83b7\u53d6\u767b\u5f55\u6311\u6218\u503c\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/login"}, method={RequestMethod.POST})
    public Object login(@RequestBody Map<String, String> req, AuditSignBean bean, HttpServletRequest request, HttpServletResponse resp) {
        String sign;
        if (null == req || req.isEmpty() || StringUtils.isBlank((CharSequence)(sign = req.get("sign")))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a [sn={},keyAlg={}]", (Object)bean.getSn(), (Object)bean.getKeyAlg());
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.loginService.login(sign, bean);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (ServiceException e) {
            this.logger.error("\u7ba1\u7406\u5458\u7cfb\u7edf\u767b\u5f55\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/logout"}, method={RequestMethod.DELETE})
    public Object logout(AuditSignBean bean, HttpServletResponse resp) {
        try {
            this.loginService.logout();
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u7ba1\u7406\u5458\u9000\u51fa\u7cfb\u7edf\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

