/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.web.superadmin;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.IssueCaCertReqVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.securityaudit.dao.models.RoleTypeEnum;
import com.xdja.pki.ca.securityaudit.service.auditadmincertmanager.AuditAdminCertManagerService;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.bean.UpdateAuditCertDTO;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SuperAdminCertController {
    @Autowired
    AuditAdminCertManagerService auditCertManagerService;
    @Autowired
    ICaManageCertService iCaManageCertService;
    @Autowired
    AuditLogService auditLogService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/v1/superadmin/history"}, method={RequestMethod.GET})
    public Object getSuperAdminCertHistoryList(Integer pageNo, Integer pageSize, HttpServletResponse resp) {
        this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u83b7\u53d6\u8d85\u7ea7\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66");
        if (null == pageNo || null == pageSize || pageNo < 1 || pageSize < 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5206\u9875\u67e5\u8be2\u8d85\u7ea7\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)pageNo, (Object)pageSize);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.auditCertManagerService.getAuditManagerCertList(Integer.valueOf(RoleTypeEnum.SUPERADIM_MANAGER.value), pageNo, pageSize);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u8d85\u7ea7\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/superadmin"}, method={RequestMethod.PUT})
    public Object updateSuperAdminCert(@RequestBody UpdateAuditCertDTO updateAuditCertDTO, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.debug("\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u5386\u53f2\u8bc1\u4e66");
        this.logger.debug("\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u4e3a:[{}]", (Object)updateAuditCertDTO);
        if (null == updateAuditCertDTO.getDnUpdate() || null == updateAuditCertDTO.getKeyUpdate() || null == updateAuditCertDTO.getValidityUpdate()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5,\u662f\u5426\u66f4\u65b0\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a[{}]", new Object[]{updateAuditCertDTO.getDnUpdate(), updateAuditCertDTO.getKeyUpdate(), updateAuditCertDTO.getValidityUpdate()});
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getDnUpdate().booleanValue() && null == updateAuditCertDTO.getCertDn()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u4e3b\u4f53\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570dn\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getKeyUpdate().booleanValue() && (null == updateAuditCertDTO.getP10() || null == updateAuditCertDTO.getSubjectPublicKeyInfo())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u5bc6\u94a5\u5bf9\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570signPublicKey\u6216encPublicKey\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getValidityUpdate().booleanValue() && null == updateAuditCertDTO.getValidity()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u6709\u6548\u671f\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570validity\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            IssueCaCertReqVO issueCaCertReqVO = new IssueCaCertReqVO();
            issueCaCertReqVO.setRoleType(Integer.valueOf(RoleTypeEnum.SUPERADIM_MANAGER.value));
            BeanUtils.copyProperties((Object)updateAuditCertDTO, (Object)issueCaCertReqVO);
            Result result = this.iCaManageCertService.doUpdateCaManagerCert(issueCaCertReqVO);
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc).append(",\u8bc1\u4e66SN=").append(bean.getSn());
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc).append(",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u8bc1\u4e66DN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8d85\u7ea7\u7ba1\u7406\u5458\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

