package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.example.Constants;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;

public class GMOKHttpsClientExample {

    private static Logger logger = LoggerFactory.getLogger(GMOKHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        // 获取 国密SSL socket factory
        SSLSocketFactory socketFactory = GMSSLContext.getClientInstance(Constants.GMSSLv11).getSocketFactory();

        X509TrustManager trustManager = new X509TrustManager() {
            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }

                String subject = chain[0].getSubjectX500Principal().getName();
                logger.info("Auto-trusted server certificate chain for: " + subject);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };

        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS)
                .tlsVersions(TlsVersion.TLS_1_2)
                .cipherSuites(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256)
                .build();

        // 为 OKHttpClient 设置 国密SSL socket factory
        OkHttpClient client = new OkHttpClient.Builder()
                .connectionSpecs(Collections.singletonList(spec))
                .sslSocketFactory(socketFactory, trustManager).build();

        Request request = new Request.Builder()
                .url(Constants.URL)
                .build();
        Response response = client.newCall(request).execute();

        if (!response.isSuccessful()) throw new IOException("Unexpected code " + response);

        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); i++) {
            logger.info(responseHeaders.name(i) + ": " + responseHeaders.value(i));
        }

        assert response.body() != null;
        logger.info(response.body().string());
    }
}
