/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.GMSSLContext;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMOKHttpsClientExample {
    private static Logger logger = LoggerFactory.getLogger((String)GMOKHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        Request request;
        SSLSocketFactory socketFactory = GMSSLContext.getClientInstance((String)"GMSSLv1.1").getSocketFactory();
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                if (chain == null || chain.length < 1 || authType == null || authType.length() < 1) {
                    throw new IllegalArgumentException();
                }
                String subject = chain[0].getSubjectX500Principal().getName();
                logger.info("Auto-trusted server certificate chain for: " + subject);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256}).build();
        OkHttpClient client = new OkHttpClient.Builder().connectionSpecs(Collections.singletonList(spec)).sslSocketFactory(socketFactory, trustManager).build();
        Response response = client.newCall(request = new Request.Builder().url("https://127.0.0.1:9020/").build()).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            logger.info(responseHeaders.name(i) + ": " + responseHeaders.value(i));
        }
        assert (response.body() != null);
        logger.info(response.body().string());
    }
}

