package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.example.Constants;
import com.xdja.pki.gmssl.https.GMHttpsClient;
import com.xdja.pki.gmssl.https.GMHttpsResponse;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyStore;
import java.security.Security;

public class GMHttpsClientClientAuthKeyStore {

    private static Logger logger = LoggerFactory.getLogger(GMHttpsClientClientAuthKeyStore.class.getName());

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }


    public static void main(String[] args) throws Exception {
//        String url = "https://11.12.85.83:5000";
        String url = Constants.HOST_127;
        String password = "password";

        KeyStore keyStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        keyStore.load(ClassLoader.getSystemResourceAsStream("client/client.keystore"), password.toCharArray());

        KeyStore trustStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        trustStore.load(ClassLoader.getSystemResourceAsStream("client/trust.keystore"), password.toCharArray());

        GMHttpsClient httpsClient = new GMHttpsClient(keyStore, password.toCharArray(), trustStore);

        GMHttpsResponse responseGet = httpsClient.get(url);
        logger.info("http get / response: " + responseGet);
        GMHttpsResponse responseGet1 = httpsClient.get(url + "get");
        logger.info("http get /get response: " + responseGet1);
        GMHttpsResponse responsePost = httpsClient.post(url + "post", "sync string body");
        logger.info("async post /post response is: " + responsePost);

    }
}