package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.example.Constants;
import com.xdja.pki.gmssl.https.GMHttpsClient;
import com.xdja.pki.gmssl.https.GMHttpsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMHttpsClientExample {
    private static Logger logger = LoggerFactory.getLogger(GMHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        String url = Constants.HOST_127;

        GMHttpsClient httpsClient = new GMHttpsClient(Constants.GMSSLv11);

        GMHttpsResponse responseGet = httpsClient.get(url + "get");
        logger.info("http get response: " + responseGet);
        GMHttpsResponse responsePost = httpsClient.post(url + "post", "sync string body");
        logger.info("async post response is: " + responsePost);

        httpsClient.asyncGet(url + "get", new GMHttpsClient.Listener() {
            @Override
            public void onResponse(GMHttpsResponse response) {
                logger.info("async get response is: " + response);
            }

            @Override
            public void onResponseError(String message) {
                logger.error("async get response error: " + message);
            }
        });

        httpsClient.asyncPost(url + "post", "async string body", new GMHttpsClient.Listener() {
            @Override
            public void onResponse(GMHttpsResponse response) {
                logger.info("async post response is: " + response);
            }

            @Override
            public void onResponseError(String message) {
                logger.error("async post response error: " + message);
            }
        });
    }
}