package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class GMHttpsServerXDJACACert {

    private static Logger logger = LoggerFactory.getLogger(GMHttpsServerXDJACACert.class.getName());

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        char[] password = "e2c1b5c1".toCharArray();

        KeyStore ks = KeyStore.getInstance("pkcs12", BouncyCastleProvider.PROVIDER_NAME);
        ks.load(ClassLoader.getSystemResourceAsStream("e2c1b5c1_sm2.p12"), password);

        String alias = ks.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey) ks.getKey(alias, password);
        Certificate[] certificates = ks.getCertificateChain(alias);
        for (Certificate certificate: certificates){
            logger.info(certificate.toString());//第二个为ca证书
        }

        Certificate caCert = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME)
                .generateCertificate(ClassLoader.getSystemResourceAsStream("root_sm2.cer"));

        //生成服务端 keystore
        KeyStore serverStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        serverStore.load(null, null);
        serverStore.setKeyEntry("server", privateKey, password, certificates);

        KeyStore trustStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", caCert);

        HttpsUtil.startGMHttpsServer(serverStore, password, trustStore, false);
    }
}