package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;

public class GMHttpsServerDBCACert {

    private static Logger logger = LoggerFactory.getLogger(GMHttpsServerDBCACert.class.getName());

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        char[] password = "DoubleCA".toCharArray();

        KeyStore ks = KeyStore.getInstance("pkcs12", BouncyCastleProvider.PROVIDER_NAME);
        ks.load(ClassLoader.getSystemResourceAsStream("dabaoca.pfx"), password);

        String alias = ks.aliases().nextElement();
        PrivateKey privateKey = (PrivateKey) ks.getKey(alias, password);
        Certificate[] certificates = ks.getCertificateChain(alias);
        for (Certificate certificate: certificates){
            logger.info(certificate.toString());
        }

        //生成服务端 keystore
        KeyStore serverStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        serverStore.load(null, null);
        serverStore.setKeyEntry("server", privateKey, password, certificates);

        KeyStore trustStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", certificates[certificates.length - 1]);

        HttpsUtil.startGMHttpsServer(serverStore, password, trustStore, false);
    }
}