package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class GMHttpsServer360CACert {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        char[] password = "password".toCharArray();

        KeyPair caKeyPair = getKeyPairFromPEM();
        X509Certificate caCert = getX509CertificateFromPEM();

        //生成服务端 keystore
        KeyStore serverStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        serverStore.load(null, null);
        serverStore.setKeyEntry("server", caKeyPair.getPrivate(), password, new X509Certificate[]{caCert});

        /*KeyPair signatureKeyPair = SSLUtils.generateSM2KeyPair();
        X509Certificate signatureCert = SSLUtils.generateEndEntityCertSignature(signatureKeyPair.getPublic(), caKeyPair.getPrivate(), caCert);
        serverStore.setKeyEntry("signature", signatureKeyPair.getPrivate(), password, new X509Certificate[]{signatureCert});

        //生成 加密秘钥、加密证书
        KeyPair encryptionKeyPair = SSLUtils.generateSM2KeyPair();
        X509Certificate encryptionCert = SSLUtils.generateEndEntityCertEncryption(encryptionKeyPair.getPublic(), caKeyPair.getPrivate(), caCert);
        serverStore.setKeyEntry("encryption", encryptionKeyPair.getPrivate(), password, new X509Certificate[]{encryptionCert});
*/
        KeyStore trustStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca", caCert);

        HttpsUtil.startGMHttpsServer(serverStore, password, trustStore, false);
    }

    public static KeyPair getKeyPairFromPEM() throws Exception{
        PEMParser pemParser = getPEMParser("key.pem");
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();

        KeyPair keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);

        return keyPair;
    }

    public static X509Certificate getX509CertificateFromPEM()throws Exception{
        PEMParser pemParser = getPEMParser("cert.pem");
        X509CertificateHolder holder = (X509CertificateHolder)pemParser.readObject();

        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        InputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
        X509Certificate certificate = (X509Certificate) certificateFactory.generateCertificate(inputStream);

        return certificate;
    }

    public static PEMParser getPEMParser(String name) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(name);
        if (inputStream == null){
            throw new Exception("Fail to find pem file: " + name);
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        return new PEMParser(reader);
    }
}