package com.xdja.pki.gmssl.example.https.server;

import com.xdja.pki.gmssl.example.https.HttpsUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.XDJAJsseProvider;

import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class GMHttpsServerClientAuth {

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider(XDJAJsseProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new XDJAJsseProvider());
        }
    }

    public static void main(String[] args) throws Exception {
        String password = "password";

        KeyStore keyStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        keyStore.load(null, null);
        HttpsUtil.setKeyEntry("63fbd873", "xdja/admin14_enc_63fbd873.p12", "enc", keyStore, password);
        HttpsUtil.setKeyEntry("63fbd873", "xdja/admin14_sign_63fbd873.p12", "sign", keyStore, password);

        KeyStore trustStore = KeyStore.getInstance("BKS", BouncyCastleProvider.PROVIDER_NAME);
        trustStore.load(null, null);

        Certificate caCert = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME)
                .generateCertificate(ClassLoader.getSystemResourceAsStream("xdja/root_sm2.cer"));

        trustStore.setCertificateEntry("ca", caCert);

        HttpsUtil.startGMHttpsServer(keyStore, password.toCharArray(), trustStore, true);
    }
}