package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.example.Constants;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ConstructorAccessor;

import javax.net.ssl.*;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;

public class GMOKHttpsClientExample {

    private static Logger logger = LoggerFactory.getLogger(GMOKHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        // 获取 国密SSL socket factory
        SSLSocketFactory socketFactory = GMSSLContext.getClientInstance(Constants.GMSSLv11).getSocketFactory();

        X509TrustManager trustManager = (X509TrustManager) GMSSLContext.getTrustAllManager();

        //反射 修改 TlsVersion 的 forJavaName
        Field forJavaName = TlsVersion.class.getDeclaredField("$VALUES");
        System.out.println(forJavaName.toString());


        //反射创建 gmssl 对象
        Constructor<TlsVersion> constructor = TlsVersion.class.getDeclaredConstructor(String.class, int.class, String.class);
        constructor.setAccessible(true);
        Field constructorAccessorField = Constructor.class.getDeclaredField("constructorAccessor");
        constructorAccessorField.setAccessible(true);
        ConstructorAccessor ca = (ConstructorAccessor) constructorAccessorField.get(constructor);
        Method acquireConstructorAccessorMethod = Constructor.class.getDeclaredMethod("acquireConstructorAccessor");
        acquireConstructorAccessorMethod.setAccessible(true);
        ca = (ConstructorAccessor) acquireConstructorAccessorMethod.invoke(constructor);
        TlsVersion gmsslVersion = (TlsVersion) ca.newInstance(new Object[]{"GMSSLv1.1", 8, "GMSSLv1.1"});
        System.out.println(gmsslVersion);

        //反射创建 cipher suite 对象
        Method constructorCipher = CipherSuite.class.getDeclaredMethod("of", String.class, int.class);
        constructorCipher.setAccessible(true);
        System.out.println(Arrays.toString(constructorCipher.getParameterTypes()));
        CipherSuite ecc_sm4_sm3 = (CipherSuite) constructorCipher.invoke(null, "ECC_SM4_SM3", 0xE013);

        //反射创建 ConnectionSpec
        Constructor<ConnectionSpec.Builder> constructorConnectionSpec = ConnectionSpec.Builder.class.getDeclaredConstructor(boolean.class);
        constructorConnectionSpec.setAccessible(true);
        ConnectionSpec.Builder builder = constructorConnectionSpec.newInstance(true);
        builder.tlsVersions(gmsslVersion);
        builder.cipherSuites(ecc_sm4_sm3);
        ConnectionSpec build = builder.build();


        ConnectionSpec spec = new ConnectionSpec.Builder(build)
                .tlsVersions(gmsslVersion)
                .cipherSuites(ecc_sm4_sm3)
                .build();

        // 为 OKHttpClient 设置 国密SSL socket factory
        OkHttpClient client = new OkHttpClient.Builder()
                .connectionSpecs(Collections.singletonList(spec))
                .sslSocketFactory(socketFactory, trustManager).build();

        Request request = new Request.Builder()
                .url("https://11.12.108.160:8444")
                .build();
        Response response = client.newCall(request).execute();

        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }

        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); i++) {
            logger.info(responseHeaders.name(i) + ": " + responseHeaders.value(i));
        }

        assert response.body() != null;
        logger.info(response.body().string());
    }
}
