/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.example.https.client;

import com.xdja.pki.gmssl.GMSSLContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ConstructorAccessor;

public class GMOKHttpsClientExample {
    private static Logger logger = LoggerFactory.getLogger((String)GMOKHttpsClientExample.class.getName());

    public static void main(String[] args) throws Exception {
        SSLSocketFactory socketFactory = GMSSLContext.getClientInstance((String)"GMSSLv1.1").getSocketFactory();
        X509TrustManager trustManager = (X509TrustManager)GMSSLContext.getTrustAllManager();
        Field forJavaName = TlsVersion.class.getDeclaredField("$VALUES");
        System.out.println(forJavaName.toString());
        Constructor constructor = TlsVersion.class.getDeclaredConstructor(String.class, Integer.TYPE, String.class);
        constructor.setAccessible(true);
        Field constructorAccessorField = Constructor.class.getDeclaredField("constructorAccessor");
        constructorAccessorField.setAccessible(true);
        ConstructorAccessor ca = (ConstructorAccessor)constructorAccessorField.get(constructor);
        Method acquireConstructorAccessorMethod = Constructor.class.getDeclaredMethod("acquireConstructorAccessor", new Class[0]);
        acquireConstructorAccessorMethod.setAccessible(true);
        ca = (ConstructorAccessor)acquireConstructorAccessorMethod.invoke(constructor, new Object[0]);
        TlsVersion gmsslVersion = (TlsVersion)ca.newInstance(new Object[]{"GMSSLv1.1", 8, "GMSSLv1.1"});
        System.out.println(gmsslVersion);
        Method constructorCipher = CipherSuite.class.getDeclaredMethod("of", String.class, Integer.TYPE);
        constructorCipher.setAccessible(true);
        System.out.println(Arrays.toString(constructorCipher.getParameterTypes()));
        CipherSuite ecc_sm4_sm3 = (CipherSuite)constructorCipher.invoke(null, "ECC_SM4_SM3", 57363);
        Constructor constructorConnectionSpec = ConnectionSpec.Builder.class.getDeclaredConstructor(Boolean.TYPE);
        constructorConnectionSpec.setAccessible(true);
        ConnectionSpec.Builder builder = (ConnectionSpec.Builder)constructorConnectionSpec.newInstance(true);
        builder.tlsVersions(new TlsVersion[]{gmsslVersion});
        builder.cipherSuites(new CipherSuite[]{ecc_sm4_sm3});
        ConnectionSpec build = builder.build();
        ConnectionSpec spec = new ConnectionSpec.Builder(build).tlsVersions(new TlsVersion[]{gmsslVersion}).cipherSuites(new CipherSuite[]{ecc_sm4_sm3}).build();
        OkHttpClient client = new OkHttpClient.Builder().connectionSpecs(Collections.singletonList(spec)).sslSocketFactory(socketFactory, trustManager).build();
        Request request = new Request.Builder().url("https://11.12.108.160:8444").build();
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            logger.info(responseHeaders.name(i) + ": " + responseHeaders.value(i));
        }
        assert (response.body() != null);
        logger.info(response.body().string());
    }
}

