package com.xdja.pki.gmssl.example.springboot.client;

import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.example.Constants;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;

public class GMRestTemplateExample {

    public static void main(String[] args) throws Exception {
        // 获取 国密SSL context
        SSLContext socketFactory = GMSSLContext.getClientInstance(Constants.GMSSLv11).getSslContext();

        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(socketFactory);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(sslConnectionSocketFactory).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
        requestFactory.setHttpClient(httpClient);

        RestTemplate restTemplate = new RestTemplate(requestFactory);

        String response = restTemplate.getForObject(Constants.HOST_127 + "get", String.class);

        System.out.println("GMRestTemplateExample get response: " + response);
    }
}
