/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.springboot.server;

import java.io.File;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/tomcat.gmssl.properties"}, ignoreResourceNotFound=true)
@EnableConfigurationProperties(value={TomcatGMSSLConnectorProperties.class})
public class TomcatGMSSLConfig {
    @Bean
    public EmbeddedServletContainerFactory servletContainer(TomcatGMSSLConnectorProperties properties) {
        TomcatEmbeddedServletContainerFactory tomcat = new TomcatEmbeddedServletContainerFactory();
        if (properties != null) {
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.httpsConnector(properties)});
        }
        return tomcat;
    }

    private Connector httpConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setScheme("http");
        connector.setPort(8080);
        connector.setSecure(false);
        connector.setRedirectPort(8443);
        return connector;
    }

    private Connector httpsConnector(TomcatGMSSLConnectorProperties properties) {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(properties.port.intValue());
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setAttribute("SSLEnabled", (Object)true);
        connector.setAttribute("clientAuth", (Object)properties.getClientAuth());
        connector.setAttribute("sslProtocol", (Object)"GMSSLv1.1");
        connector.setAttribute("keystorePass", (Object)properties.getKeystorePassword());
        connector.setAttribute("keystoreFile", (Object)properties.getKeystore());
        connector.setAttribute("keystoreProvider", (Object)"BC");
        connector.setAttribute("keystoreType", (Object)"BKS");
        connector.setAttribute("truststorePass", (Object)properties.getTruststorePassword());
        connector.setAttribute("truststoreFile", (Object)properties.getTruststore().getAbsolutePath());
        connector.setAttribute("truststoreProvider", (Object)"BC");
        connector.setAttribute("truststoreType", (Object)"BKS");
        connector.setProperty("sslImplementationName", "com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");
        return connector;
    }

    @ConfigurationProperties(prefix="tomcat.gmssl")
    public static class TomcatGMSSLConnectorProperties {
        private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
        private Integer port = 8443;
        private File keystore;
        private String keystorePassword;
        private File truststore;
        private String truststorePassword;
        private String clientAuth;

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public File getKeystore() {
            return this.keystore;
        }

        public void setKeystore(File keystore) {
            this.keystore = keystore;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public File getTruststore() {
            return this.truststore;
        }

        public void setTruststore(File truststore) {
            this.truststore = truststore;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }

        public String getClientAuth() {
            return this.clientAuth;
        }

        public void setClientAuth(String clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}

