package com.xdja.pki.gmssl.hsm.init;

import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.core.utils.GMSSLCertPathUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;

public class GMSSLHSMConfig {

    /**
     * gmssl-hsm-server IP
     */
    private String ip;
    /**
     * gmssl-hsm-server GMSSL https Port 双向认证
     */
    private String port;
    /**
     * 获取到的keystore密码
     */
    private String keyStorePassword;
    /**
     * gmssl-hsm-server 客户端签名密钥 存储路径、类型、提供者、密码
     */
    private String signPath;
    private String signType;
    private String signProvider;
    private String signPassword;
    /**
     * gmssl-hsm-server 客户端加密密钥 存储路径、类型、提供者、密码
     */
    private String encPassword;
    private String encPath;
    private String encType;
    private String encProvider;
    /**
     * gmssl-hsm-server 客户端信任证书链 存储路径、类型、提供者、密码
     */
    private String trustPath;
    private String trustType;
    private String trustProvider;
    private String trustPassword;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getKeyStorePassword() {
        return keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getSignPath() {
        return signPath;
    }

    public void setSignPath(String signPath) {
        this.signPath = signPath;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getSignProvider() {
        return signProvider;
    }

    public void setSignProvider(String signProvider) {
        this.signProvider = signProvider;
    }

    public String getSignPassword() {
        return signPassword;
    }

    public void setSignPassword(String signPassword) {
        this.signPassword = signPassword;
    }

    public String getEncPassword() {
        return encPassword;
    }

    public void setEncPassword(String encPassword) {
        this.encPassword = encPassword;
    }

    public String getEncPath() {
        return encPath;
    }

    public void setEncPath(String encPath) {
        this.encPath = encPath;
    }

    public String getEncType() {
        return encType;
    }

    public void setEncType(String encType) {
        this.encType = encType;
    }

    public String getEncProvider() {
        return encProvider;
    }

    public void setEncProvider(String encProvider) {
        this.encProvider = encProvider;
    }

    public String getTrustPath() {
        return trustPath;
    }

    public void setTrustPath(String trustPath) {
        this.trustPath = trustPath;
    }

    public String getTrustType() {
        return trustType;
    }

    public void setTrustType(String trustType) {
        this.trustType = trustType;
    }

    public String getTrustProvider() {
        return trustProvider;
    }

    public void setTrustProvider(String trustProvider) {
        this.trustProvider = trustProvider;
    }

    public String getTrustPassword() {
        return trustPassword;
    }

    public void setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
    }

    public KeyStore getTrustKeyStore() throws IOException {
        return GMSSLContext.getTrustStore(this.trustPath, this.trustType, this.trustProvider, this.trustPassword);
    }

    public KeyStore getKeyStore() throws IOException {
        return GMSSLContext.getKeystore(this.signPath + ";" + this.encPath,
                this.signType+ ";" + this.encType,
                this.signProvider+ ";" + this.encProvider,
                this.signPassword + ";" + this.encPassword
        );
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GMSSLHSMConfig that = (GMSSLHSMConfig) o;
        return Objects.equals(ip, that.ip) &&
                Objects.equals(port, that.port) &&
                Objects.equals(keyStorePassword, that.keyStorePassword) &&
                Objects.equals(signPath, that.signPath) &&
                Objects.equals(signType, that.signType) &&
                Objects.equals(signProvider, that.signProvider) &&
                Objects.equals(signPassword, that.signPassword) &&
                Objects.equals(encPassword, that.encPassword) &&
                Objects.equals(encPath, that.encPath) &&
                Objects.equals(encType, that.encType) &&
                Objects.equals(encProvider, that.encProvider) &&
                Objects.equals(trustPath, that.trustPath) &&
                Objects.equals(trustType, that.trustType) &&
                Objects.equals(trustProvider, that.trustProvider) &&
                Objects.equals(trustPassword, that.trustPassword);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ip, port, keyStorePassword, signPath, signType, signProvider, signPassword, encPassword, encPath, encType, encProvider, trustPath, trustType, trustProvider, trustPassword);
    }

    @Override
    public String toString() {
        return "ip=" + ip + '\n' +
                "port=" + port + '\n' +
                "keyStorePassword=" + keyStorePassword + '\n' +
                "signPath=" + signPath + '\n' +
                "signType=" + signType + '\n' +
                "signProvider=" + signProvider + '\n' +
                "signPassword=" + signPassword + '\n' +
                "encPassword=" + encPassword + '\n' +
                "encPath=" + encPath + '\n' +
                "encType=" + encType + '\n' +
                "encProvider=" + encProvider + '\n' +
                "trustPath=" + trustPath + '\n' +
                "trustType=" + trustType + '\n' +
                "trustProvider=" + trustProvider + '\n' +
                "trustPassword=" + trustPassword;
    }

    public void saveConfig(String configPath) throws IOException {
        byte[] context = this.toString().getBytes();
        GMSSLFileUtils.writeFile(configPath, context);
    }

    public static GMSSLHSMConfig parseConfig(String configPath) throws IOException {
        byte[] context = GMSSLFileUtils.readAllBytes(configPath);
        String configStr = new String(context);
        return parseConfigStr(configStr);
    }

    public static GMSSLHSMConfig parseConfigStr(String configStr) throws IOException {
        String[] configs = configStr.split("\n");
        if (configs.length != GMSSLHSMConfig.class.getDeclaredFields().length){
            throw new IOException("gmssl hsm config item count error: " + configs.length);
        }
        GMSSLHSMConfig hsmConfig = new GMSSLHSMConfig();
        Class<? extends GMSSLHSMConfig> configClass = hsmConfig.getClass();
        for (String config : configs) {
            String[] cc = config.split("=");
            if (cc.length == 1 && "trustPassword".equals(cc[0])){
                String key = cc[0];
                cc = new String[]{key, ""};
            }
            if (cc.length != 2 || cc[0] == null || cc[0].isEmpty()){
                throw new IOException("hsm config item error: " + config);
            }

            try {
                Method m = configClass.getDeclaredMethod("set" + cc[0].substring(0,1).toUpperCase() +cc[0].substring(1), String.class);
                m.invoke(hsmConfig, cc[1]);
            } catch (NoSuchMethodException | InvocationTargetException | IllegalAccessException e) {
                throw new IOException("hsm config set value error: " + config, e);
            }
        }
        return hsmConfig;
    }
}
