package com.xdja.pki.gmssl.hsm.server.config;

import org.apache.catalina.connector.Connector;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import java.io.File;

@Configuration
@PropertySource(value = "classpath:/tomcat.gmssl.properties", ignoreResourceNotFound = true)
@EnableConfigurationProperties(TomcatGMSSLConfig.TomcatGMSSLConnectorProperties.class)
public class TomcatGMSSLConfig {

    @Bean
    public TomcatServletWebServerFactory servletContainer(TomcatGMSSLConnectorProperties properties) {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        if (properties != null) {
            tomcat.addAdditionalTomcatConnectors(httpsConnector(properties));
        }
        return tomcat;
    }

    private Connector httpConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setScheme("http");
        connector.setPort(8080);
        connector.setSecure(false);
        connector.setRedirectPort(8443);
        return connector;
    }

    /**
     * <Connector port="8443" protocol="org.apache.coyote.http11.Http11Protocol"
     * maxThreads="150" SSLEnabled="true" scheme="https" secure="true"
     * clientAuth="false" sslProtocol="GMSSLv1.1"
     * sslImplementationName="com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation"
     * keystoreFile="D:\keys\sm2\server.keystore"
     * keystorePass="password"
     * keystoreProvider="BC"
     * keystoreType="BKS"
     * truststoreFile="D:\keys\sm2\trust.keystore"
     * truststorePass="password"
     * truststoreProvider="BC"
     * truststoreType="BKS"
     * />
     *
     * @return tomcat https Connector
     */
    private Connector httpsConnector(TomcatGMSSLConnectorProperties properties) {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(properties.port);

        connector.setScheme("https");
        connector.setSecure(true);
        connector.setAttribute("SSLEnabled", true);
        connector.setAttribute("clientAuth", properties.getClientAuth());
        connector.setAttribute("sslProtocol", "GMSSLv1.1");

        connector.setAttribute("keystorePass", properties.getKeystorePassword());
        connector.setAttribute("keystoreFile", properties.getKeystore().getAbsolutePath());
        connector.setAttribute("keystoreProvider", "BC");
        connector.setAttribute("keystoreType", "BKS");

        connector.setAttribute("truststorePass", properties.getTruststorePassword());
        connector.setAttribute("truststoreFile", properties.getTruststore().getAbsolutePath());
        connector.setAttribute("truststoreProvider", "BC");
        connector.setAttribute("truststoreType", "BKS");

        connector.setProperty("sslImplementationName", "com.xdja.pki.gmssl.tomcat.plugin.XDJAJSSEImplementation");

        return connector;
    }


    @ConfigurationProperties(prefix = "tomcat.gmssl")
    public static class TomcatGMSSLConnectorProperties {
        private String protocol = "org.apache.coyote.http11.Http11NioProtocol";

        private Integer port = 8443;

        private File keystore;
        private String keystorePassword;

        private File truststore;
        private String truststorePassword;

        private String clientAuth;

        public String getProtocol() {
            return protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Integer getPort() {
            return port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public File getKeystore() {
            return keystore;
        }

        public void setKeystore(File keystore) {
            this.keystore = keystore;
        }

        public String getKeystorePassword() {
            return keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public File getTruststore() {
            return truststore;
        }

        public void setTruststore(File truststore) {
            this.truststore = truststore;
        }

        public String getTruststorePassword() {
            return truststorePassword;
        }

        public void setTruststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
        }

        public String getClientAuth() {
            return clientAuth;
        }

        public void setClientAuth(String clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}