package com.xdja.pki.gmssl.hsm.server.controller;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.hsm.server.constant.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.io.IOException;

/**
 * @author: houzhe
 * @date: 2021-11-01
 * @description: KeyStore controller
 **/
@RestController
public class HsmSevererController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    @GetMapping("/v1/keys")
    public Object queryAll() {
        try {
            return GMSSLFileUtils.readAllBytes(Constants.PATH + File.separator + Constants.KEY_STORE_NAME + ".keystore");
        } catch (IOException e) {
            logger.error("获取KeyStore失败", e);
            return null;
        }
    }
}
