/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.hsm.server;

import com.xdja.pki.gmssl.core.utils.GMSSLCertPathUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLCertUtils;
import com.xdja.pki.gmssl.x509.utils.GMSSLExtensionUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class HsmServerApplication {
    private static final Logger logger = LoggerFactory.getLogger(HsmServerApplication.class);

    public static void main(String[] args) {
        if (null != args && args.length != 0 && "init".equalsIgnoreCase(args[0])) {
            try {
                HsmServerApplication.init();
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
            logger.info("\u521d\u59cb\u5316\u6210\u529f");
            return;
        }
        SpringApplication.run(HsmServerApplication.class, (String[])args);
    }

    private static void init() throws Exception {
        AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -1);
        Date noBefore = calendar.getTime();
        calendar.add(1, 30);
        Date noAfter = calendar.getTime();
        String rootDn = "cn=root,o=gmssl-hsm,o=xdja,c=cn";
        KeyPair rootKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> rootExtensions = new ArrayList<Extension>();
        rootExtensions.add(GMSSLExtensionUtils.genRootCertKeyUsageExtension());
        X509Certificate rootCert = GMSSLCertUtils.generateCertByBC((String)rootDn, (String)rootDn, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootKeyPair.getPrivate(), (PublicKey)rootKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), rootExtensions);
        KeyStore trustKeyStore = GMSSLKeyStoreUtils.generateGMSSLTrustStoreWithBKS((X509Certificate)rootCert);
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)trustKeyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm", (String)"trust");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        certificates.add(rootCert);
        byte[] bytes = GMSSLCertPathUtils.generateP7b(certificates);
        GMSSLFileUtils.writeFile((String)"/home/xdja/conf/ccsa/hsm", (String)"trust.p7b", (byte[])bytes);
        KeyStore keyStore = KeyStore.getInstance("BKS", "BC");
        keyStore.load(null, null);
        keyStore.setKeyEntry("trust", rootKeyPair.getPrivate(), "xdja1234".toCharArray(), new X509Certificate[]{rootCert});
        GMSSLKeyStoreUtils.saveGMSSLBKSKeyStore((KeyStore)keyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm", (String)"trust");
        KeyStore serverKeyStore = HsmServerApplication.generateKeyStore((Date)noBefore, (Date)noAfter, (AtomicLong)serialNumber, (X509Certificate)rootCert, (String)rootDn, (PrivateKey)rootKeyPair.getPrivate());
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)serverKeyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm", (String)"server");
        KeyStore clientKeyStore = HsmServerApplication.generateKeyStore((Date)noBefore, (Date)noAfter, (AtomicLong)serialNumber, (X509Certificate)rootCert, (String)rootDn, (PrivateKey)rootKeyPair.getPrivate());
        GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)clientKeyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm", (String)"client");
        GMSSLKeyStoreUtils.saveGMSSLPfx((KeyStore)clientKeyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm");
    }

    private static KeyStore generateKeyStore(Date noBefore, Date noAfter, AtomicLong serialNumber, X509Certificate rootCert, String rootDn, PrivateKey rootPrivateKey) throws Exception {
        String signDn = "cn=sign,o=gmssl-hsm,o=xdja,c=cn";
        KeyPair signKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> signExtensions = new ArrayList<Extension>();
        signExtensions.add(GMSSLExtensionUtils.genSignatureCertKeyUsageExtension());
        signExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)signKeyPair.getPublic()));
        signExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate signCert = GMSSLCertUtils.generateCertByBC((String)rootDn, (String)signDn, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)signKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), signExtensions);
        String encDn = "cn=enc,o=gmssl-hsm,o=xdja,c=cn";
        KeyPair encKeyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        ArrayList<Extension> encExtensions = new ArrayList<Extension>();
        encExtensions.add(GMSSLExtensionUtils.genEncryptCertKeyUsageExtension());
        encExtensions.add(GMSSLExtensionUtils.genSubjectKeyIdentifierExtension((PublicKey)encKeyPair.getPublic()));
        encExtensions.add(GMSSLExtensionUtils.genAuthorityKeyIdentifierExtension((X509Certificate)rootCert));
        X509Certificate encCert = GMSSLCertUtils.generateCertByBC((String)rootDn, (String)encDn, (BigInteger)BigInteger.valueOf(serialNumber.getAndIncrement()), (Date)noBefore, (Date)noAfter, (PrivateKey)rootPrivateKey, (PublicKey)encKeyPair.getPublic(), (String)GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName(), encExtensions);
        return GMSSLKeyStoreUtils.generateGMSSLKeyStoreWithBKS((String)"xdja1234", (X509Certificate)rootCert, (String)"sign", (PrivateKey)signKeyPair.getPrivate(), (X509Certificate)signCert, (String)"enc", (PrivateKey)encKeyPair.getPrivate(), (X509Certificate)encCert);
    }
}

