/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.gmssl.hsm.server.runner;

import com.xdja.pki.gmssl.core.utils.GMSSLFileUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLRandomUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class KeyStoreRunner
implements ApplicationRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void run(ApplicationArguments args) {
        String[] sourceArgs = args.getSourceArgs();
        if (null == sourceArgs || sourceArgs.length == 0) {
            return;
        }
        int sm2Count = 0;
        int symCount = 0;
        HashMap<Integer, Integer> rsaCount = new HashMap<Integer, Integer>();
        for (String arg : sourceArgs) {
            String[] split = arg.split("-");
            String alg = split[0];
            if (split.length == 2) {
                if ("sm2".equalsIgnoreCase(alg)) {
                    sm2Count = Integer.parseInt(split[1]);
                    continue;
                }
                if (!"sym".equalsIgnoreCase(alg)) continue;
                symCount = Integer.parseInt(split[1]);
                continue;
            }
            if (split.length != 3 || !"rsa".equalsIgnoreCase(alg)) continue;
            rsaCount.put(Integer.valueOf(split[1]), Integer.valueOf(split[2]));
        }
        HashMap sortMap = new HashMap(rsaCount.size());
        rsaCount.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> {
            Integer cfr_ignored_0 = (Integer)sortMap.put(e.getKey(), e.getValue());
        });
        if (this.checkFile(sm2Count, symCount, sortMap)) {
            return;
        }
        this.generateKeyStore(sm2Count, symCount, sortMap);
    }

    private boolean checkFile(int sm2Count, int symCount, Map<Integer, Integer> rsaCount) {
        boolean checkFlag = true;
        String keyStorePath = "/home/xdja/conf/ccsa/hsm" + File.separator + "key" + ".keystore";
        try {
            KeyStore keyStore = GMSSLKeyStoreUtils.readKeyStoreFromPath((String)keyStorePath, (char[])"xdja1234".toCharArray());
            for (int i = 1; i <= sm2Count; ++i) {
                if (keyStore.containsAlias(MessageFormat.format("asym_sign_{0}", i)) && keyStore.containsAlias(MessageFormat.format("asym_enc_{0}", i))) continue;
                checkFlag = false;
                break;
            }
            int rsaIndexBegin = sm2Count;
            for (Map.Entry<Integer, Integer> entry : rsaCount.entrySet()) {
                Integer count = entry.getValue();
                for (int i = 1; i <= count; ++i) {
                    if (keyStore.containsAlias(MessageFormat.format("asym_sign_{0}", rsaIndexBegin + i)) && keyStore.containsAlias(MessageFormat.format("asym_enc_{0}", rsaIndexBegin + i))) continue;
                    checkFlag = false;
                    break;
                }
                if (!checkFlag) break;
                rsaIndexBegin += count.intValue();
            }
            for (int i = 1; i <= symCount; ++i) {
                if (keyStore.containsAlias(MessageFormat.format("sym_{0}", i))) continue;
                checkFlag = false;
                break;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            this.logger.warn("key.keystore\u89e3\u6790\u5931\u8d25", (Throwable)e);
            checkFlag = false;
        }
        if (!checkFlag) {
            this.logger.warn("key.keystore\u89e3\u6790\u5931\u8d25\u6216\u7f3a\u5931\uff0c\u91cd\u65b0\u6210\u529fkey.keystore");
            GMSSLFileUtils.deleteFile((String)keyStorePath);
        }
        return checkFlag;
    }

    private void generateKeyStore(int sm2Count, int symCount, Map<Integer, Integer> rsaCount) {
        Certificate serverSignCert;
        KeyStore serverKeyStore;
        String serverKeyStorePath = "/home/xdja/conf/ccsa/hsm" + File.separator + "server" + ".keystore";
        try {
            serverKeyStore = GMSSLKeyStoreUtils.readKeyStoreFromPath((String)serverKeyStorePath, (char[])"xdja1234".toCharArray());
            serverSignCert = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)serverKeyStore, (String)"sign");
        }
        catch (Exception e) {
            serverKeyStore = null;
            serverSignCert = null;
        }
        if (null == serverKeyStore || null == serverSignCert) {
            this.logger.error("\u751f\u6210key.keystore\u5931\u8d25\uff0c\u9700\u5148\u521d\u59cb\u5316");
            return;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("BKS", "BC");
            keyStore.load(null, null);
            for (int i = 1; i <= sm2Count; ++i) {
                Object keyPair = GMSSLX509Utils.generateSM2KeyPair();
                keyStore.setKeyEntry(MessageFormat.format("asym_sign_{0}", i), ((KeyPair)keyPair).getPrivate(), "xdja1234".toCharArray(), new Certificate[]{serverSignCert});
                keyPair = GMSSLX509Utils.generateSM2KeyPair();
                keyStore.setKeyEntry(MessageFormat.format("asym_enc_{0}", i), ((KeyPair)keyPair).getPrivate(), "xdja1234".toCharArray(), new Certificate[]{serverSignCert});
                this.logger.info("SM2\u5bc6\u94a5\u7d22\u5f15[{}]\u751f\u6210\u6210\u529f", (Object)i);
            }
            int rsaIndexBegin = sm2Count;
            for (Map.Entry entry : rsaCount.entrySet()) {
                Integer len = (Integer)entry.getKey();
                Integer count = (Integer)entry.getValue();
                for (int i = 1; i <= count; ++i) {
                    KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)len);
                    keyStore.setKeyEntry(MessageFormat.format("asym_sign_{0}", rsaIndexBegin + i), keyPair.getPrivate(), "xdja1234".toCharArray(), new Certificate[]{serverSignCert});
                    keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)len);
                    keyStore.setKeyEntry(MessageFormat.format("asym_enc_{0}", rsaIndexBegin + i), keyPair.getPrivate(), "xdja1234".toCharArray(), new Certificate[]{serverSignCert});
                    this.logger.info("RSA-{}\u5bc6\u94a5\u7d22\u5f15[{}]\u751f\u6210\u6210\u529f", (Object)len, (Object)i);
                }
                rsaIndexBegin += count.intValue();
            }
            for (int i = 1; i <= symCount; ++i) {
                SecretKeySpec secretKeySpec = new SecretKeySpec(GMSSLRandomUtils.generateRandom((int)16), "SM4");
                keyStore.setKeyEntry(MessageFormat.format("sym_{0}", i), secretKeySpec, "xdja1234".toCharArray(), null);
                this.logger.info("\u5bf9\u79f0\u5bc6\u94a5\u7d22\u5f15[{}]\u751f\u6210\u6210\u529f", (Object)i);
            }
            GMSSLKeyStoreUtils.saveGMSSLKeyStore((KeyStore)keyStore, (String)"xdja1234", (String)"/home/xdja/conf/ccsa/hsm", (String)"key");
            this.logger.info("key.keystore\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210key.keystore\u5931\u8d25", (Throwable)e);
        }
    }
}

