package com.xdja.pki.gmssl.https;

import java.util.HashMap;

public class GMHttpsRequest {
    private HashMap<String, String> headers;
    private String uri;
    private GMHttpsMethod method;
    private String body;

    public GMHttpsRequest(HashMap<String, String> headers, String uri, GMHttpsMethod method, String body) {
        this.headers = headers;
        this.uri = uri;
        this.method = method;
        this.body = body;
    }

    public GMHttpsRequest(HashMap<String, String> headers, String uri, String method, String body) {
        this.headers = headers;
        this.uri = uri;
        this.body = body;
        this.method = GMHttpsMethod.valueOf(method);
    }

    public HashMap<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public GMHttpsMethod getMethod() {
        return method;
    }

    public void setMethod(GMHttpsMethod method) {
        this.method = method;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return "GMHttpsRequest{" +
                "headers=" + headers +
                ", uri='" + uri + '\'' +
                ", method=" + method +
                ", body='" + body + '\'' +
                '}';
    }
}
