package com.xdja.pki.gmssl.https;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.nio.charset.StandardCharsets;

class GMHttpsUtils {

    private static Logger logger = LoggerFactory.getLogger(GMHttpsUtils.class.getName());

    static void writeBytes(OutputStream outputStream, byte[] body) throws IOException {
        if (body != null) {
            IOUtils.write(body, outputStream);
        }
    }

    static void writeString(OutputStream outputStream, String body) throws IOException {
        if (body != null) {
            IOUtils.write(body, outputStream);
        }
    }

    static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, bos);
        return bos.toByteArray();
    }

    static String readString(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder response = new StringBuilder();
        String str = null;
        while ((str = bufferedReader.readLine()) != null) {
            response.append(str);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        return response.toString();
    }
}
