package com.xdja.pki.gmssl.http.bean;

import com.xdja.pki.gmssl.GMSSLContext;

import java.io.IOException;
import java.security.KeyStore;

public class GMSSLHttpsClientConfig extends GMSSLHttpClientConfig {

    /**
     * 是否开启 SSL 即 使用 https
     */
    private boolean sslEnabled;

    /**
     * SSL 协议
     */
    private String sslProtocol;

    /**
     * 客户端 keystore 私钥、证书
     */
    private KeyStore clientKeyStore;

    /**
     * 客户端 私钥文件 路径
     */
    private String clientStoreFile;

    /**
     * 客户端 keystore 密码
     */
    private String clientKeyStorePassword;

    /**
     * 客户端 keystore provider
     */
    private String clientKeyStoreProvider;

    /**
     * 客户端 keystore type
     * 支持 PKCS12、BKS、JKS
     */
    private String clientKeyStoreType;

    /**
     * 客户端 trust store 信任锚点
     */
    private KeyStore trustStore;

    /**
     * 客户端 信任列表文件 路径
     */
    private String trustStoreFile;

    /**
     * 客户端 trust store 密码
     */
    private String trustStorePassword;

    /**
     * 客户端 trust store provider
     */
    private String trustStoreProvider;

    /**
     * 客户端 trust store 类型
     * 支持 PKCS7(p7b)、PKCS12、PEM、CRT
     */
    private String trustStoreType;

    public boolean isSslEnabled() {
        return sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getSslProtocol() {
        return sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public KeyStore getClientKeyStore() throws IOException {
        if (clientKeyStore == null && clientStoreFile != null){
            clientKeyStore =  GMSSLContext.getKeystore(clientStoreFile, clientKeyStoreType, clientKeyStoreProvider, clientKeyStorePassword);
        }
        return clientKeyStore;
    }

    public void setClientKeyStore(KeyStore clientKeyStore) {
        this.clientKeyStore = clientKeyStore;
    }

    public String getClientKeyStorePassword() {
        return clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public String getClientKeyStoreProvider() {
        return clientKeyStoreProvider;
    }

    public void setClientKeyStoreProvider(String clientKeyStoreProvider) {
        this.clientKeyStoreProvider = clientKeyStoreProvider;
    }

    public String getClientKeyStoreType() {
        return clientKeyStoreType;
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.clientKeyStoreType = clientKeyStoreType;
    }

    public KeyStore getTrustStore() throws IOException {
        if (trustStore == null && trustStoreFile != null){
            trustStore =  GMSSLContext.getTrustStore(trustStoreFile, trustStoreType, trustStoreProvider, trustStorePassword);
        }
        return trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreProvider() {
        return trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getClientStoreFile() {
        return clientStoreFile;
    }

    public void setClientStoreFile(String clientStoreFile) {
        this.clientStoreFile = clientStoreFile;
    }

    public String getTrustStoreFile() {
        return trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @Override
    public String toString() {
        return "GMSSLHttpsClientConfig{" +
                "sslEnabled=" + sslEnabled +
                ", sslProtocol='" + sslProtocol + '\'' +
                ", clientKeyStore=" + clientKeyStore +
                ", clientKeyStorePassword='" + clientKeyStorePassword + '\'' +
                ", clientKeyStoreProvider='" + clientKeyStoreProvider + '\'' +
                ", clientKeyStoreType='" + clientKeyStoreType + '\'' +
                ", trustStore=" + trustStore +
                ", trustStorePassword='" + trustStorePassword + '\'' +
                ", trustStoreProvider='" + trustStoreProvider + '\'' +
                ", trustStoreType='" + trustStoreType + '\'' +
                ", connectTimeout=" + connectTimeout +
                ", readTimeout=" + readTimeout +
                '}';
    }
}
