package com.xdja.pki.gmssl.http.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMSSLHttpException extends Exception {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GMSSLHttpErrorCode code;

    public GMSSLHttpException(GMSSLHttpErrorCode code) {
        this.code = code;
        logger.error("code " + code.getValue());
    }

    public GMSSLHttpException(String message, GMSSLHttpErrorCode code) {
        super(message);
        this.code = code;
        logger.error("message : " + message + " code : " + code.getValue());
    }

    public GMSSLHttpException(String message, Throwable cause, GMSSLHttpErrorCode code) {
        super(message, cause);
        this.code = code;
        logger.error("message : " + message + " code : " + code.getValue(), cause);
    }

    public GMSSLHttpException(Throwable cause, GMSSLHttpErrorCode code) {
        super(cause);
        this.code = code;
        logger.error("code : " + code.getValue(), cause);
    }

    public GMSSLHttpErrorCode getCode() {
        return code;
    }

    public void setCode(GMSSLHttpErrorCode code) {
        this.code = code;
    }
}
