package com.xdja.pki.gmssl.http.bean;

public enum GMSSLHttpMethod {
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE");

    private String value;

    GMSSLHttpMethod(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }

    public static boolean isDoOutput(String method) {
        return POST.getValue().equalsIgnoreCase(method) || PUT.getValue().equalsIgnoreCase(method);
    }
}