package org.bouncycastle.tls;

import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/**
 * A basic PSK Identity holder.
 */
public class BasicTlsPSKIdentity
    implements TlsPSKIdentity
{
    protected byte[] identity;
    protected byte[] psk;

    public BasicTlsPSKIdentity(byte[] identity, byte[] psk)
    {
        this.identity = Arrays.clone(identity);
        this.psk = Arrays.clone(psk);
    }

    public BasicTlsPSKIdentity(String identity, byte[] psk)
    {
        this.identity = Strings.toUTF8ByteArray(identity);
        this.psk = Arrays.clone(psk);
    }

    @Override
    public void skipIdentityHint()
    {
    }

    @Override
    public void notifyIdentityHint(byte[] psk_identity_hint)
    {
    }

    @Override
    public byte[] getPSKIdentity()
    {
        return identity;
    }

    @Override
    public byte[] getPSK()
    {
        return psk;
    }

}
