/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProvX509TrustManagerImpl
implements ProvX509TrustManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Provider pkixProvider;
    private final Set<X509Certificate> trustedCerts;
    private final PKIXParameters baseParameters;

    private Set<X509Certificate> getTrustedCerts(Set<TrustAnchor> trustAnchors) {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>(trustAnchors.size());
        for (TrustAnchor trustAnchor : trustAnchors) {
            X509Certificate trustedCert;
            if (trustAnchor == null || (trustedCert = trustAnchor.getTrustedCert()) == null) continue;
            result.add(trustedCert);
        }
        return result;
    }

    ProvX509TrustManagerImpl(Provider pkixProvider, Set<TrustAnchor> trustAnchors) throws InvalidAlgorithmParameterException {
        this.pkixProvider = pkixProvider;
        this.trustedCerts = this.getTrustedCerts(trustAnchors);
        this.baseParameters = new PKIXBuilderParameters(trustAnchors, (CertSelector)new X509CertSelector());
        this.baseParameters.setRevocationEnabled(false);
    }

    ProvX509TrustManagerImpl(Provider pkixProvider, PKIXParameters baseParameters) throws InvalidAlgorithmParameterException {
        this.pkixProvider = pkixProvider;
        this.trustedCerts = this.getTrustedCerts(baseParameters.getTrustAnchors());
        if (baseParameters instanceof PKIXBuilderParameters) {
            this.baseParameters = baseParameters;
        } else {
            this.baseParameters = new PKIXBuilderParameters(baseParameters.getTrustAnchors(), baseParameters.getTargetCertConstraints());
            this.baseParameters.setCertStores(baseParameters.getCertStores());
            this.baseParameters.setRevocationEnabled(baseParameters.isRevocationEnabled());
            this.baseParameters.setCertPathCheckers(baseParameters.getCertPathCheckers());
            this.baseParameters.setDate(baseParameters.getDate());
            this.baseParameters.setAnyPolicyInhibited(baseParameters.isAnyPolicyInhibited());
            this.baseParameters.setPolicyMappingInhibited(baseParameters.isPolicyMappingInhibited());
            this.baseParameters.setExplicitPolicyRequired(baseParameters.isExplicitPolicyRequired());
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        this.validatePath(x509Certificates);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[this.trustedCerts.size()]);
    }

    protected void validatePath(X509Certificate[] x509Certificates) throws CertificateException {
        if (x509Certificates == null || x509Certificates.length < 1) {
            throw new IllegalArgumentException("'x509Certificates' must be a chain of at least one certificate");
        }
        this.logger.debug("validatePath certificate subjectDN: {} sn: {} issueDN: {}", new Object[]{x509Certificates[0].getSubjectDN().toString(), x509Certificates[0].getSerialNumber(), x509Certificates[0].getIssuerDN().toString()});
        X509Certificate eeCert = x509Certificates[0];
        if (this.trustedCerts.contains(eeCert)) {
            return;
        }
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(x509Certificates)), this.pkixProvider);
            CertPathBuilder pathBuilder = CertPathBuilder.getInstance("PKIX", this.pkixProvider);
            X509CertSelector constraints = (X509CertSelector)this.baseParameters.getTargetCertConstraints().clone();
            constraints.setCertificate(eeCert);
            PKIXBuilderParameters param = (PKIXBuilderParameters)this.baseParameters.clone();
            param.addCertStore(certStore);
            param.setTargetCertConstraints(constraints);
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)((Object)pathBuilder.build(param));
            result.getTrustAnchor();
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("unable to process certificates: " + e.getMessage(), e);
        }
    }
}

