/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.jsse.provider.EngineCreator;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoProvider;
import org.bouncycastle.tls.crypto.impl.bc.GMSSLCryptoType;
import org.bouncycastle.util.Strings;

public class XDJAJsseProvider
extends Provider {
    public static final String PROVIDER_NAME = "XDJAJSSE";
    private static final double PROVIDER_VERSION = 1.0004;
    private static final String PROVIDER_INFO = "XDJA Bouncy Castle JSSE Provider Version 1.0.4";
    private Map<String, BcJsseService> serviceMap = new HashMap<String, BcJsseService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final boolean isInFipsMode = this.configure(new BcTlsCryptoProvider());
    private static final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public XDJAJsseProvider() {
        super(PROVIDER_NAME, 1.0004, PROVIDER_INFO);
    }

    private boolean configure(final BcTlsCryptoProvider baseCryptoProvider) {
        boolean fipsMode = false;
        this.addAlgorithmImplementation("KeyManagerFactory.X.509", "org.bouncycastle.jsse.provider.KeyManagerFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvKeyManagerFactorySpi();
            }
        });
        this.addAlias("Alg.Alias.KeyManagerFactory.X509", "X.509");
        this.addAlias("Alg.Alias.KeyManagerFactory.PKIX", "X.509");
        this.addAlgorithmImplementation("TrustManagerFactory.PKIX", "org.bouncycastle.jsse.provider.TrustManagerFactory", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvTrustManagerFactorySpi(baseCryptoProvider.getPkixProvider());
            }
        });
        this.addAlias("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.addAlias("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.addAlgorithmImplementation("SSLContext.TLS", "org.bouncycastle.jsse.provider.SSLContext.TLS", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(false, baseCryptoProvider, null);
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.2", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_2", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.DEFAULT", "org.bouncycastle.jsse.provider.SSLContext.Default", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                try {
                    ProvSSLContextSpi defaultSSLContextSpi = new ProvSSLContextSpi(false, baseCryptoProvider, null);
                    defaultSSLContextSpi.engineInit(null, null, null);
                    return defaultSSLContextSpi;
                }
                catch (GeneralSecurityException e) {
                    return null;
                }
            }
        });
        this.addAlgorithmImplementation("SSLContext.GMSSLV1.1", "org.bouncycastle.jsse.provider.SSLContext.GMSSLv1_1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                baseCryptoProvider.setType(GMSSLCryptoType.BC);
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"GMSSLv1.1"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.GMSSLSDFPCIEV1.1", "org.bouncycastle.jsse.provider.SSLContext.GMSSLSDFPCIEv1_1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                baseCryptoProvider.setType(GMSSLCryptoType.SDF_PCIE);
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"GMSSLv1.1"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.GMSSLSDFYUNHSMV1.1", "org.bouncycastle.jsse.provider.SSLContext.GMSSLSDFYUNHSMv1_1", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                baseCryptoProvider.setType(GMSSLCryptoType.SDF_YUNHSM);
                return new ProvSSLContextSpi(false, baseCryptoProvider, new String[]{"GMSSLv1.1"});
            }
        });
        return false;
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase((String)algorithm);
        BcJsseService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + upperCaseAlgName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Object key : this.keySet()) {
                String sKey = (String)key;
                if (sKey.startsWith(aliasString) && this.get(key).equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)this.get(sKey));
            }
            service = new BcJsseService(this, type, upperCaseAlgName, className, aliases, XDJAJsseProvider.getAttributeMap(attributes), this.creatorMap.get(className));
            this.serviceMap.put(type + "." + upperCaseAlgName, service);
        }
        return service;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> serviceSet = super.getServices();
        HashSet<Provider.Service> bcServiceSet = new HashSet<Provider.Service>();
        for (Provider.Service service : serviceSet) {
            bcServiceSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return bcServiceSet;
    }

    private static Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    public boolean isFipsMode() {
        return this.isInFipsMode;
    }

    private static class BcJsseService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcJsseService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }
}

