/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCompression;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsNullCompression;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected int[] clientSupportedGroups;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto);
        this.keyExchangeFactory = keyExchangeFactory;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[]{0};
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected int getMaximumNegotiableCurveBits() {
        if (this.clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(this.clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        if (this.clientSupportedGroups == null) {
            return NamedGroup.getMaximumFiniteFieldBits();
        }
        int maxBits = 0;
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(this.clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, int availFiniteFieldBits, Vector sigAlgs) {
        return Arrays.contains((int[])this.offeredCipherSuites, (int)cipherSuite) && TlsUtils.isValidCipherSuiteForVersion(cipherSuite, this.serverVersion) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && availFiniteFieldBits >= TlsDHUtils.getMinimumFiniteFieldBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectCurve(int minimumCurveBits) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(minimumCurveBits);
        }
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int namedGroup = this.clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectDefaultCurve(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : (minimumCurveBits <= 571 ? 14 : -1)));
    }

    protected TlsDHConfig selectDefaultDHConfig(int minimumFiniteFieldBits) {
        int namedGroup = minimumFiniteFieldBits <= 2048 ? 256 : (minimumFiniteFieldBits <= 3072 ? 257 : (minimumFiniteFieldBits <= 4096 ? 258 : (minimumFiniteFieldBits <= 6144 ? 259 : (minimumFiniteFieldBits <= 8192 ? 260 : -1))));
        return TlsDHUtils.createNamedDHConfig(namedGroup);
    }

    protected TlsDHConfig selectDHConfig() throws IOException {
        int minimumFiniteFieldBits = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        TlsDHConfig dhConfig = this.selectDHConfig(minimumFiniteFieldBits);
        if (dhConfig == null) {
            throw new TlsFatalAlert(80);
        }
        return dhConfig;
    }

    protected TlsDHConfig selectDHConfig(int minimumFiniteFieldBits) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultDHConfig(minimumFiniteFieldBits);
        }
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int namedGroup = this.clientSupportedGroups[i];
            if (NamedGroup.getFiniteFieldBits(namedGroup) < minimumFiniteFieldBits) continue;
            return new TlsDHConfig(namedGroup);
        }
        return null;
    }

    protected TlsECConfig createECCSM2Config() throws IOException {
        int namedGroup = 29;
        boolean compressed = TlsECCUtils.isCompressionPreferred(this.clientECPointFormats, namedGroup);
        TlsECConfig ecConfig = new TlsECConfig();
        ecConfig.setNamedGroup(namedGroup);
        ecConfig.setPointCompression(compressed);
        return ecConfig;
    }

    protected TlsECConfig selectECConfig() throws IOException {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int namedGroup = this.selectCurve(minimumCurveBits);
        if (namedGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        boolean compressed = TlsECCUtils.isCompressionPreferred(this.clientECPointFormats, namedGroup);
        TlsECConfig ecConfig = new TlsECConfig();
        ecConfig.setNamedGroup(namedGroup);
        ecConfig.setPointCompression(compressed);
        return ecConfig;
    }

    @Override
    public void init(TlsServerContext context) {
        this.context = context;
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        return null;
    }

    @Override
    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
        this.clientVersion = clientVersion;
    }

    @Override
    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback && this.getMaximumVersion().isLaterVersionOf(this.clientVersion)) {
            throw new TlsFatalAlert(86);
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    @Override
    public void notifyOfferedCompressionMethods(short[] offeredCompressionMethods) throws IOException {
        this.offeredCompressionMethods = offeredCompressionMethods;
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (clientExtensions != null) {
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension(clientExtensions);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientExtensions);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(clientExtensions);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion maximumVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(maximumVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(maximumVersion)) {
                this.serverVersion = maximumVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        Vector sigAlgs = TlsUtils.getUsableSignatureAlgorithms(this.supportedSignatureAlgorithms);
        int availCurveBits = this.getMaximumNegotiableCurveBits();
        int availFiniteFieldBits = this.getMaximumNegotiableFiniteFieldBits();
        int[] cipherSuites = this.getCipherSuites();
        for (int i = 0; i < cipherSuites.length; ++i) {
            int cipherSuite = cipherSuites[i];
            boolean isSelectableCipherSuite = this.isSelectableCipherSuite(cipherSuite, availCurveBits, availFiniteFieldBits, sigAlgs);
            boolean selectCipherSuite = this.selectCipherSuite(cipherSuite);
            this.logger.debug("CipherSuites {} isSelectableCipherSuite {} selectCipherSuite {}", new Object[]{CipherSuite.getName(cipherSuite), isSelectableCipherSuite, selectCipherSuite});
            if (!isSelectableCipherSuite || !selectCipherSuite) continue;
            return cipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public short getSelectedCompressionMethod() throws IOException {
        short[] compressionMethods = this.getCompressionMethods();
        for (int i = 0; i < compressionMethods.length; ++i) {
            if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)compressionMethods[i])) continue;
            this.selectedCompressionMethod = compressionMethods[i];
            return this.selectedCompressionMethod;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        if (this.context.getServerVersion().isGMSSL()) {
            return null;
        }
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension(this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), this.serverECPointFormats);
        }
        if (this.certificateStatusRequest != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_status_request, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), encryptionAlgorithm, macAlgorithm);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

