/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.GMSSLUtils;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedECCSM2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsECCSM2KeyExchange
extends AbstractTlsKeyExchange {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected TlsCertificate peerCertificate;
    public BcDefaultTlsCredentialedECCSM2 serverCredentials = null;
    protected TlsCertificate encryptionCertificate;
    protected TlsVerifier verifier = null;
    protected TlsSecret preMasterSecret;

    public TlsECCSM2KeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, ecConfigVerifier, null, clientECPointFormats, serverECPointFormats);
    }

    public TlsECCSM2KeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, null, ecConfig, null, serverECPointFormats);
    }

    private TlsECCSM2KeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, TlsECConfig ecConfig, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms);
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof BcDefaultTlsCredentialedECCSM2)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (BcDefaultTlsCredentialedECCSM2)serverCredentials;
        this.encryptionCertificate = this.serverCredentials.getEncryptionCertificate();
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            this.logger.error("processServerCertificate server cert is empty, alert bad_certificate");
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.encryptionCertificate = GMSSLUtils.getEncryptionCertificate(serverCertificate);
        this.verifier = GMSSLUtils.getSignatureCertificate(serverCertificate).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] signature = GMSSLUtils.generateECCSM2ServerKeyExchangeSignature(this.context, this.serverCredentials, this.encryptionCertificate);
        TlsUtils.writeOpaque16(signature, out);
        byte[] signed = out.toByteArray();
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"generateServerKeyExchange signed", (byte[])signed);
        return signed;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        byte[] signature = TlsUtils.readOpaque16(input);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"processServerKeyExchange signature", (byte[])signature);
        DigitallySigned signedParams = new DigitallySigned(new SignatureAndHashAlgorithm(7, 4), signature);
        GMSSLUtils.verifyECCSM2ServerKeyExchangeSignature(this.context, this.verifier, signedParams, this.encryptionCertificate);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 64, 80};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsUtils.generateEncryptedPreMasterSecret(this.context, this.encryptionCertificate, output);
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        if (clientCertificate.isEmpty()) {
            this.logger.error("processClientCertificate client cert is empty, alert bad_certificate");
            throw new TlsFatalAlert(42);
        }
        this.peerCertificate = GMSSLUtils.getSignatureCertificate(clientCertificate);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"server receive encrypted pre master secret: ", (byte[])encryptedPreMasterSecret);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

