/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signedParams.getSignature());
    }
}

