/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final InputStream consumed;
    protected final String host;
    protected final boolean autoClose;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    private static Socket checkSocket(Socket s) throws SocketException {
        if (s == null) {
            throw new NullPointerException("'s' cannot be null");
        }
        if (!s.isConnected()) {
            throw new SocketException("'s' is not a connected socket");
        }
        return s;
    }

    protected ProvSSLSocketWrap(ProvSSLContextSpi context, ContextData contextData, Socket s, InputStream consumed, boolean autoClose) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(s);
        this.consumed = consumed;
        this.host = null;
        this.autoClose = autoClose;
        this.useClientMode = false;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketWrap(ProvSSLContextSpi context, ContextData contextData, Socket s, String host, int port, boolean autoClose) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.wrapSocket = ProvSSLSocketWrap.checkSocket(s);
        this.consumed = null;
        this.host = host;
        this.autoClose = autoClose;
        this.useClientMode = true;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    protected void closeSocket() throws IOException {
        if (this.autoClose) {
            this.wrapSocket.close();
        } else if (this.protocol != null) {
            // empty if block
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    @Override
    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (Exception e) {
            this.logger.info("Level.FINE Failed to establish connection", (Throwable)e);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public int getPort() {
        return this.wrapSocket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    @Override
    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : connection.getSession();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.wrapSocket.setKeepAlive(on);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrapSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.wrapSocket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.wrapSocket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrapSocket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.wrapSocket.setSoTimeout(timeout);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrapSocket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.wrapSocket.setTrafficClass(tc);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.useClientMode == mode) {
            return;
        }
        if (this.protocol != null) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
        this.context.updateDefaultProtocols(this.sslParameters, !this.useClientMode);
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = this.wrapSocket.getInputStream();
            if (this.consumed != null) {
                input = new SequenceInputStream(this.consumed, input);
            }
            OutputStream output = this.wrapSocket.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public String toString() {
        return this.wrapSocket.toString();
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException e) {
                this.logger.info("check client trust error {}", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException e) {
                this.logger.info("check server trust error {}", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                if (ProvSSLSocketWrap.this.protocol != null) {
                    ProvSSLSocketWrap.this.protocol.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketWrap.this.protocol.writeApplicationData(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary(true);
                ProvSSLSocketWrap.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketWrap.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary(true);
            return ProvSSLSocketWrap.this.protocol.readApplicationData(b, off, len);
        }
    }
}

