/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Engine;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.GMSSLUtils;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2SignerSdf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcDefaultTlsCredentialedECCSM2
extends DefaultTlsCredentialedSigner
implements TlsCredentialedDecryptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AbstractTlsCrypto crypto;
    protected PrivateKey signaturePrivateKey;
    protected PrivateKey encryptionPrivateKey;
    protected Certificate gmsslCertificate;

    private static TlsSigner makeSigner(BcTlsCrypto crypto, PrivateKey privateKey) {
        AsymmetricKeyParameter parameter;
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        try {
            parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        if (!(parameter instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        BcTlsSM2Signer signer = new BcTlsSM2Signer(crypto, parameter);
        return signer;
    }

    private static TlsSigner makeSigner(BcTlsCryptoSdf crypto, SdfPrivateKey privateKey) {
        return new BcTlsSM2SignerSdf(crypto, (AsymmetricKeyParameter)new SdfECKeyParameters(privateKey));
    }

    private static Certificate makeSignerCertificate(Certificate gmsslCertificate) {
        return new Certificate(new TlsCertificate[]{GMSSLUtils.getSignatureCertificate(gmsslCertificate)});
    }

    public BcDefaultTlsCredentialedECCSM2(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, Certificate gmsslCertificate, PrivateKey signaturePrivateKey, PrivateKey encryptionPrivateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedECCSM2.makeSigner(crypto, signaturePrivateKey), BcDefaultTlsCredentialedECCSM2.makeSignerCertificate(gmsslCertificate), signatureAndHashAlgorithm);
        this.gmsslCertificate = gmsslCertificate;
        this.signaturePrivateKey = signaturePrivateKey;
        this.encryptionPrivateKey = encryptionPrivateKey;
        this.crypto = crypto;
    }

    public BcDefaultTlsCredentialedECCSM2(TlsCryptoParameters cryptoParams, BcTlsCryptoSdf crypto, Certificate gmsslCertificate, SdfPrivateKey signaturePrivateKey, SdfPrivateKey encryptionPrivateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedECCSM2.makeSigner(crypto, signaturePrivateKey), BcDefaultTlsCredentialedECCSM2.makeSignerCertificate(gmsslCertificate), signatureAndHashAlgorithm);
        this.gmsslCertificate = gmsslCertificate;
        this.signaturePrivateKey = signaturePrivateKey;
        this.encryptionPrivateKey = encryptionPrivateKey;
        this.crypto = crypto;
    }

    @Override
    public Certificate getCertificate() {
        return this.gmsslCertificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        if (this.crypto instanceof BcTlsCrypto) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)this.encryptionPrivateKey.getEncoded());
            if (privateKeyInfo == null) {
                throw new IllegalArgumentException("'privateKey' type not supported: " + this.encryptionPrivateKey.getClass().getName());
            }
            AsymmetricKeyParameter parameter = PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo);
            return this.safeDecryptPreMasterSecret((ECKeyParameters)parameter, ciphertext);
        }
        if (this.crypto instanceof BcTlsCryptoSdf) {
            return this.safeDecryptPreMasterSecretSdf((BcTlsCryptoSdf)this.crypto, ciphertext);
        }
        throw new IllegalArgumentException("'crypto' type not supported: " + this.crypto.getClass().getName());
    }

    protected TlsSecret safeDecryptPreMasterSecret(ECKeyParameters ecServerPrivateKey, byte[] encryptedPreMasterSecret) throws TlsFatalAlert {
        try {
            byte[] M = GMSSLSM2EncryptUtils.decryptASN1ByBC((ECKeyParameters)ecServerPrivateKey, (byte[])encryptedPreMasterSecret);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"safeDecryptPreMasterSecret", (byte[])M);
            return this.crypto.createSecret(M);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
    }

    protected TlsSecret safeDecryptPreMasterSecretSdf(BcTlsCryptoSdf crypto, byte[] encryptedPreMasterSecret) throws TlsFatalAlert {
        try {
            SdfPrivateKey pPrivateKey = (SdfPrivateKey)this.signaturePrivateKey;
            SdfECKeyParameters parameters = new SdfECKeyParameters(pPrivateKey);
            SdfSM2Engine pSM2Engine = new SdfSM2Engine(crypto.getSdfCryptoType());
            pSM2Engine.init(false, (CipherParameters)parameters);
            byte[] M = pSM2Engine.decryptASN1(encryptedPreMasterSecret);
            GMSSLByteArrayUtils.printHexBinary((Logger)this.logger, (String)"safeDecryptPreMasterSecret", (byte[])M);
            pSM2Engine.release();
            return crypto.createSecret(M);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(51, (Throwable)e);
        }
    }

    public TlsCertificate getSignatureCertificate() {
        return GMSSLUtils.getSignatureCertificate(this.gmsslCertificate);
    }

    public TlsCertificate getEncryptionCertificate() {
        return GMSSLUtils.getEncryptionCertificate(this.gmsslCertificate);
    }
}

