/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.GMSSLCryptoType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcTlsCryptoProvider
implements TlsCryptoProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private GMSSLCryptoType type = GMSSLCryptoType.BC;

    public void setType(GMSSLCryptoType type) {
        this.type = type;
    }

    @Override
    public TlsCrypto create(SecureRandom random) {
        this.logger.debug("create TlsCrypto type " + (Object)((Object)this.type));
        switch (this.type) {
            case BC: {
                try {
                    if (random == null) {
                        random = SecureRandom.getInstance("DEFAULT");
                    }
                    return new BcTlsCrypto(random);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("unable to create TlsCrypto: " + e.getMessage(), e);
                }
            }
            case SDF_PCIE: {
                return new BcTlsCryptoSdf(SdfCryptoType.PCIE);
            }
            case SDF_YUNHSM: {
                return new BcTlsCryptoSdf(SdfCryptoType.YUNHSM);
            }
        }
        throw new IllegalStateException("unable to create TlsCrypto: " + (Object)((Object)this.type), null);
    }

    @Override
    public TlsCrypto create(SecureRandom keyRandom, SecureRandom nonceRandom) {
        return this.create(keyRandom);
    }

    public Provider getPkixProvider() {
        return new BouncyCastleProvider();
    }
}

