/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsSM2VerifierSdf
extends BcTlsVerifier {
    private SdfCryptoType sdfCryptoType;

    public BcTlsSM2VerifierSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
        this.sdfCryptoType = crypto.getSdfCryptoType();
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws TlsFatalAlert {
        try {
            SdfSM2Signer signer = new SdfSM2Signer(this.sdfCryptoType);
            signer.init(false, (CipherParameters)this.publicKey);
            signer.update(hash, 0, hash.length);
            boolean is = signer.verifySignature(signedParams.getSignature());
            signer.release();
            return is;
        }
        catch (SdfSDKException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

