/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class BcTlsSecretSdf
extends AbstractTlsSecret {
    protected final BcTlsCryptoSdf crypto;

    public BcTlsSecretSdf(BcTlsCryptoSdf crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        byte[] labelSeed = Arrays.concatenate((byte[])Strings.toByteArray((String)label), (byte[])seed);
        byte[] result = this.prf_1_2(prfAlgorithm, this.data, labelSeed, length);
        return this.crypto.adoptLocalSecret(result);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) {
        HMac mac = new HMac((Digest)new SM3Digest());
        mac.init((CipherParameters)new KeyParameter(secret, secretOff, secretLen));
        byte[] a = seed;
        int macSize = mac.getMacSize();
        byte[] b1 = new byte[macSize];
        byte[] b2 = new byte[macSize];
        for (int pos = 0; pos < output.length; pos += macSize) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, pos, Math.min(macSize, output.length - pos));
        }
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] secret, byte[] labelSeed, int length) {
        Digest digest = this.crypto.createDigest(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        byte[] result = new byte[length];
        this.hmacHash(digest, secret, 0, secret.length, labelSeed, result);
        return result;
    }
}

