package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;

import java.io.IOException;

/**
 * Operator supporting the generation of RSA signatures using the BC light-weight API.
 */
//GMSSL SUPPORT: 2018/7/31 for ecc sm2 signer
public class BcTlsSM2Signer extends BcTlsSigner {
    public BcTlsSM2Signer(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        SM2Signer signer = new SM2Signer();
        signer.init(true, new ParametersWithRandom(privateKey, crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        } catch (CryptoException e) {
            throw new TlsFatalAlert(AlertDescription.internal_error, e);
        }
    }
}
