package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;

import java.io.IOException;

/**
 * Operator supporting the generation of RSA signatures using the BC light-weight API.
 */
//GMSSL SUPPORT: 2018/7/31 for ecc sm2 signer
public class BcTlsSM2SignerSdf extends BcTlsSigner {

    private SdfCryptoType sdfCryptoType;

    protected BcTlsSM2SignerSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter privateKey) {
        super(crypto, privateKey);
        this.sdfCryptoType = crypto.getSdfCryptoType();
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            SdfSM2Signer signer = new SdfSM2Signer(this.sdfCryptoType);
            signer.init(true, privateKey);
            signer.update(hash, 0, hash.length);
            byte[] sign = signer.generateSignature();
            signer.release();
            return sign;
        } catch (CryptoException | SdfSDKException e) {
            throw new TlsFatalAlert(AlertDescription.internal_error, e);
        }
    }
}
