package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;

public abstract class BcTlsVerifier implements TlsVerifier {
    protected final TlsCrypto crypto;
    protected final AsymmetricKeyParameter publicKey;

    protected BcTlsVerifier(TlsCrypto crypto, AsymmetricKeyParameter publicKey) {
        if (crypto == null) {
            throw new NullPointerException("'crypto' cannot be null");
        }
        if (publicKey == null) {
            throw new NullPointerException("'publicKey' cannot be null");
        }
        if (publicKey.isPrivate()) {
            throw new IllegalArgumentException("'publicKey' must be public");
        }

        this.crypto = crypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        return null;
    }
}
