package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2BaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2Signer;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.TlsFatalAlert;

/**
 * Implementation class for the verification of the raw ECDSA signature type using the BC light-weight API.
 */
public class BcTlsSM2VerifierSdf extends BcTlsVerifier {

    public BcTlsSM2VerifierSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws TlsFatalAlert {
        try {
            SdfSM2BaseSigner signer;
            BcTlsCryptoSdf cryptoSdf = (BcTlsCryptoSdf) this.crypto;
            if (cryptoSdf.isUseBC()) {
                signer = new SdfSM2SignerSM3(cryptoSdf.getSdfCryptoType());
            } else {
                signer = new SdfSM2Signer(cryptoSdf.getSdfCryptoType());
            }
            signer.init(false, publicKey);
            signer.update(hash, 0, hash.length);
            boolean is = signer.verifySignature(signedParams.getSignature());
            signer.release();
            return is;
        } catch (SdfSDKException e) {
            throw new TlsFatalAlert(AlertDescription.internal_error, e);
        }
    }
}
