/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfECEngine;
import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM3Digest;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM4Engine;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificateSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSecretSdf;
import org.bouncycastle.tls.crypto.impl.bc.CBCBlockCipherSdf;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcTlsCryptoSdf
extends AbstractTlsCrypto {
    private static Logger logger = LoggerFactory.getLogger((String)BcTlsCryptoSdf.class.getName());
    private final SdfCryptoType sdfCryptoType;
    private final SecureRandom entropySource;
    private final boolean useBC;

    public BcTlsCryptoSdf(SdfCryptoType sdfCryptoType, SecureRandom entropySource, boolean useBC) {
        this.sdfCryptoType = sdfCryptoType;
        this.entropySource = entropySource;
        this.useBC = useBC;
    }

    public SdfCryptoType getSdfCryptoType() {
        return this.sdfCryptoType;
    }

    BcTlsSecretSdf adoptLocalSecret(byte[] data) {
        return new BcTlsSecretSdf(this, data);
    }

    public boolean isUseBC() {
        return this.useBC;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.useBC) {
            return this.entropySource;
        }
        try {
            return new SdfRandom(this.sdfCryptoType);
        }
        catch (SdfSDKException e) {
            logger.error("getSecureRandom new sdf random error", (Throwable)e);
            throw new IllegalStateException("unable to create SdfRandom: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificateSdf(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 1008: {
                return this.createSM4Cipher(cryptoParams, 16, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return null;
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return null;
    }

    @Override
    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificateSdf bcCert = BcTlsCertificateSdf.convert(this, certificate);
        bcCert.validateKeyUsage(32);
        final AsymmetricKeyParameter keyParameter = bcCert.getPublicKey();
        if (keyParameter instanceof SdfECKeyParameters) {
            return new TlsEncryptor(){

                @Override
                public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                    try {
                        SdfECEngine psm2Engine = new SdfECEngine(BcTlsCryptoSdf.this.sdfCryptoType);
                        psm2Engine.init(true, (CipherParameters)keyParameter);
                        byte[] cipher = psm2Engine.encryptASN1(input);
                        psm2Engine.release();
                        return cipher;
                    }
                    catch (SdfSDKException e) {
                        throw new IOException(e);
                    }
                }
            };
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        if (this.useBC) {
            final DigestRandomGenerator nonceGen = new DigestRandomGenerator(this.createDigest((short)7));
            if (additionalSeedMaterial != null && additionalSeedMaterial.length > 0) {
                nonceGen.addSeedMaterial(additionalSeedMaterial);
            }
            byte[] seed = new byte[this.createDigest((short)7).getDigestSize()];
            this.entropySource.nextBytes(seed);
            nonceGen.addSeedMaterial(seed);
            return new TlsNonceGenerator(){

                @Override
                public byte[] generateNonce(int size) {
                    byte[] nonce = new byte[size];
                    nonceGen.nextBytes(nonce);
                    return nonce;
                }
            };
        }
        return new TlsNonceGenerator(){

            @Override
            public byte[] generateNonce(int size) {
                byte[] nonce = new byte[size];
                SdfRandom sdfRandom = (SdfRandom)BcTlsCryptoSdf.this.getSecureRandom();
                sdfRandom.nextBytes(nonce);
                return nonce;
            }
        };
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return true;
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1008: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    @Override
    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    @Override
    public TlsSecret generatePreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        if (this.useBC) {
            this.entropySource.nextBytes(data);
        } else {
            SdfRandom sdfRandom = (SdfRandom)this.getSecureRandom();
            sdfRandom.nextBytes(data);
        }
        GMSSLByteArrayUtils.printHexBinary((Logger)logger, (String)"client generate pre master secret random", (byte[])data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    @Override
    public Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 7: {
                if (this.useBC) {
                    return new SM3Digest();
                }
                try {
                    return new SdfSM3Digest(this.sdfCryptoType);
                }
                catch (SdfSDKException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    @Override
    public TlsHash createHash(short algorithm) {
        return new BcTlsHash(algorithm, this.createDigest(algorithm));
    }

    private static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 7: {
                if (hash instanceof SM3Digest) {
                    return new SM3Digest((SM3Digest)hash);
                }
                if (hash instanceof SdfSM3Digest) {
                    try {
                        return new SdfSM3Digest((SdfSM3Digest)hash);
                    }
                    catch (SdfSDKException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                throw new IllegalArgumentException("unknown Hash: " + hash.getClass());
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    private TlsCipher createSM4Cipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createSM4BlockCipher(), true), new BlockOperator(this.createSM4BlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected BlockCipher createSM4Engine() {
        if (this.useBC) {
            return new SM4Engine();
        }
        try {
            return new SdfSM4Engine(this.sdfCryptoType);
        }
        catch (SdfSDKException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected BlockCipher createSM4BlockCipher() {
        return new CBCBlockCipherSdf(this.createSM4Engine());
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        return new HMacOperator(this.createDigest(TlsUtils.getHashAlgorithmForHMACAlgorithm(macAlgorithm)));
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        return null;
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        return null;
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        return null;
    }

    public class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = digest instanceof SdfSM3Digest ? new HMac((Digest)new SM3Digest()) : new HMac(digest);
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.hmac.init((CipherParameters)new KeyParameter(key, keyOff, keyLen));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        @Override
        public void reset() {
            this.hmac.reset();
        }

        public void releaseConnection() {
        }
    }

    public class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV((CipherParameters)this.key, new byte[this.cipher.getBlockSize()]));
        }

        @Override
        public void init(byte[] iv, int ivOff, int ivLen) {
            this.cipher.init(this.isEncrypting, (CipherParameters)new ParametersWithIV(null, iv, ivOff, ivLen));
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int blockSize = this.cipher.getBlockSize();
            for (int i = 0; i < inputLength; i += blockSize) {
                this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            }
            return inputLength;
        }

        @Override
        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }

        public void releaseConnection() {
            if (this.cipher instanceof CBCBlockCipherSdf) {
                ((CBCBlockCipherSdf)this.cipher).releaseConnection();
            }
        }
    }

    public static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short hashAlgorithm, Digest digest) {
            this.hashAlgorithm = hashAlgorithm;
            this.digest = digest;
        }

        @Override
        public void update(byte[] data, int offSet, int length) {
            this.digest.update(data, offSet, length);
        }

        @Override
        public byte[] calculateHash() {
            byte[] rv = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(rv, 0);
            return rv;
        }

        @Override
        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCryptoSdf.cloneDigest(this.hashAlgorithm, this.digest));
        }

        @Override
        public void reset() {
            this.digest.reset();
        }

        public void releaseConnection() {
            if (this.digest instanceof SdfSM3Digest) {
                ((SdfSM3Digest)this.digest).releaseConnection();
            }
        }
    }
}

