/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.crypto.interfaces.DHPrivateKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificateSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

abstract class JsseUtils {
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean contains(String[] values, String value) {
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] copyOf(String[] data, int newLength) {
        String[] tmp = new String[newLength];
        System.arraycopy(data, 0, tmp, 0, Math.min(data.length, newLength));
        return tmp;
    }

    public static String getAuthTypeClient(short clientCertificateType) throws IOException {
        switch (clientCertificateType) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeServer(int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 11: {
                return "DH_anon";
            }
            case 7: {
                return "DH_DSS";
            }
            case 9: {
                return "DH_RSA";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 14: {
                return "DHE_PSK";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 20: {
                return "ECDH_anon";
            }
            case 16: {
                return "ECDH_ECDSA";
            }
            case 18: {
                return "ECDH_RSA";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 24: {
                return "ECDHE_PSK";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 101: {
                return "ECC_SM2";
            }
            case 1: {
                return "RSA";
            }
            case 15: {
                return "RSA_PSK";
            }
            case 21: {
                return "SRP";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static Certificate getCertificateMessage(TlsCrypto crypto, X509Certificate[] chain) throws IOException {
        if (chain == null || chain.length < 1) {
            return Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] certificateList = new TlsCertificate[chain.length];
        try {
            for (int i = 0; i < chain.length; ++i) {
                certificateList[i] = crypto.createCertificate(chain[i].getEncoded());
            }
        }
        catch (CertificateEncodingException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        return new Certificate(certificateList);
    }

    public static X509Certificate[] getX509CertificateChain(TlsCrypto crypto, Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return EMPTY_CHAIN;
        }
        try {
            X509Certificate[] chain = new X509Certificate[certificateMessage.getLength()];
            if (crypto instanceof JcaTlsCrypto) {
                for (int i = 0; i < chain.length; ++i) {
                    chain[i] = JcaTlsCertificate.convert((JcaTlsCrypto)crypto, certificateMessage.getCertificateAt(i)).getX509Certificate();
                }
            } else if (crypto instanceof BcTlsCrypto) {
                for (int i = 0; i < chain.length; ++i) {
                    chain[i] = BcTlsCertificate.convert((BcTlsCrypto)crypto, certificateMessage.getCertificateAt(i)).getX509Certificate();
                }
            } else if (crypto instanceof BcTlsCryptoSdf) {
                for (int i = 0; i < chain.length; ++i) {
                    chain[i] = BcTlsCertificateSdf.convert((BcTlsCryptoSdf)crypto, certificateMessage.getCertificateAt(i)).getX509Certificate();
                }
            } else {
                throw new IOException("unknown crypto: " + crypto.getClass().getName());
            }
            return chain;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate[] getX509CertificateChain(java.security.cert.Certificate[] chain) {
        if (chain == null) {
            return null;
        }
        if (chain instanceof X509Certificate[]) {
            return (X509Certificate[])chain;
        }
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            java.security.cert.Certificate c = chain[i];
            if (!(c instanceof X509Certificate)) {
                return null;
            }
            x509Chain[i] = (X509Certificate)c;
        }
        return x509Chain;
    }

    public static X500Principal getSubject(TlsCrypto crypto, Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return null;
        }
        try {
            if (crypto instanceof JcaTlsCrypto) {
                return JcaTlsCertificate.convert((JcaTlsCrypto)crypto, certificateMessage.getCertificateAt(0)).getX509Certificate().getSubjectX500Principal();
            }
            if (crypto instanceof BcTlsCrypto) {
                return BcTlsCertificate.convert((BcTlsCrypto)crypto, certificateMessage.getCertificateAt(0)).getX509Certificate().getSubjectX500Principal();
            }
            if (crypto instanceof BcTlsCryptoSdf) {
                return BcTlsCertificateSdf.convert((BcTlsCryptoSdf)crypto, certificateMessage.getCertificateAt(0)).getX509Certificate().getSubjectX500Principal();
            }
            throw new RuntimeException("unknown tls crypto " + crypto.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String getAlertLogMessage(String root, short alertLevel, short alertDescription) {
        return root + " " + AlertLevel.getText(alertLevel) + " " + AlertDescription.getText(alertDescription) + " alert";
    }

    static Vector getSupportedSignatureAlgorithms(TlsCrypto crypto) {
        short[] hashAlgorithms = new short[]{2, 3, 4, 7, 5, 6};
        short[] signatureAlgorithms = new short[]{1, 3, 4};
        Vector result = new Vector();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                JsseUtils.addIfSupported(crypto, result, new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]));
            }
        }
        JsseUtils.addIfSupported(crypto, result, new SignatureAndHashAlgorithm(2, 2));
        return result;
    }

    public static boolean isUsableKeyForServer(int keyExchangeAlgorithm, PrivateKey privateKey) throws IOException {
        if (privateKey == null) {
            return false;
        }
        String algorithm = privateKey.getAlgorithm();
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return privateKey instanceof DHPrivateKey || "DH".equals(algorithm);
            }
            case 16: 
            case 18: {
                return privateKey instanceof ECPrivateKey || "ECDH".equals(algorithm);
            }
            case 17: {
                return privateKey instanceof ECPrivateKey || "EC".equals(algorithm);
            }
            case 3: 
            case 4: 
            case 22: {
                return privateKey instanceof DSAPrivateKey || "DSA".equals(algorithm);
            }
            case 1: 
            case 5: 
            case 6: 
            case 15: 
            case 19: 
            case 23: {
                return privateKey instanceof RSAPrivateKey || "RSA".equals(algorithm);
            }
            case 101: {
                return privateKey instanceof ECPrivateKey || "ECC".equals(algorithm);
            }
        }
        return false;
    }

    static Set<X500Principal> toX500Principals(X500Name[] names) throws IOException {
        if (names == null || names.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Principal> principals = new HashSet<X500Principal>(names.length);
        for (int i = 0; i < names.length; ++i) {
            X500Name name = names[i];
            if (name == null) continue;
            principals.add(new X500Principal(name.getEncoded("DER")));
        }
        return principals;
    }

    static X500Name toX500Name(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof X500Principal) {
            return X500Name.getInstance((Object)((X500Principal)principal).getEncoded());
        }
        return new X500Name(principal.getName());
    }

    static Set<X500Name> toX500Names(Principal[] principals) {
        if (principals == null || principals.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Name> names = new HashSet<X500Name>(principals.length);
        for (int i = 0; i != principals.length; ++i) {
            X500Name name = JsseUtils.toX500Name(principals[i]);
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    private static void addIfSupported(TlsCrypto crypto, Vector v, SignatureAndHashAlgorithm alg) {
        if (crypto.hasSignatureAndHashAlgorithm(alg)) {
            v.addElement(alg);
        }
    }

    static Constructor getDeclaredConstructor(final Class clazz, final Class<?> ... parameterTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

            @Override
            public Constructor run() {
                try {
                    return clazz.getDeclaredConstructor(parameterTypes);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static Class loadClass(Class sourceClass, final String className) {
        try {
            ClassLoader loader = sourceClass.getClassLoader();
            if (loader != null) {
                return loader.loadClass(className);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Class>(){

                @Override
                public Class run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static BCSNIServerName convertSNIServerName(ServerName serverName) {
        switch (serverName.getNameType()) {
            case 0: {
                return new BCSNIHostName(serverName.getHostName());
            }
        }
        return null;
    }

    static BCSNIServerName findMatchingSNIServerName(ServerNameList serverNameList, Collection<BCSNIMatcher> sniMatchers) {
        Enumeration serverNames = serverNameList.getServerNameList().elements();
        while (serverNames.hasMoreElements()) {
            BCSNIServerName sniServerName = JsseUtils.convertSNIServerName((ServerName)serverNames.nextElement());
            for (BCSNIMatcher sniMatcher : sniMatchers) {
                if (sniMatcher == null || sniMatcher.getType() != sniServerName.getType() || !sniMatcher.matches(sniServerName)) continue;
                return sniServerName;
            }
        }
        return null;
    }

    static String stripQuotes(String s) {
        int sLast;
        if (s != null && (sLast = s.length() - 1) > 0 && s.charAt(0) == '\"' && s.charAt(sLast) == '\"') {
            return s.substring(1, sLast);
        }
        return s;
    }
}

