/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.TlsMAC;

public class JceTlsMAC
implements TlsMAC {
    private final String algorithm;
    private Mac mac;

    public JceTlsMAC(Mac mac, String algorithm) {
        this.mac = mac;
        this.algorithm = algorithm;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        try {
            this.mac.init(new SecretKeySpec(key, keyOff, keyLen, this.algorithm));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.mac.update(input, inOff, length);
    }

    @Override
    public byte[] calculateMAC() {
        return this.mac.doFinal();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public void reset() {
        this.mac.reset();
    }
}

