package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.tls.DigitallySigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementation class for the verification of the raw ECDSA signature type using the BC light-weight API.
 */
public class BcTlsSM2Verifier extends BcTlsVerifier {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SM2Signer signer = new SM2Signer();
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        byte[] signature = signedParams.getSignature();
        boolean verified = signer.verifySignature(signature);
        if (!verified){
            ECPublicKeyParameters pub = (ECPublicKeyParameters) this.publicKey;
            GMSSLByteArrayUtils.printHexBinary(logger, "hash", hash);
            GMSSLByteArrayUtils.printHexBinary(logger, "signature", signature);
            GMSSLByteArrayUtils.printHexBinary(logger, "public key ", pub.getQ().getEncoded(false));
        }
        return verified;
    }
}
