package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.TlsFatalAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementation class for the verification of the raw ECDSA signature type using the BC light-weight API.
 */
public class BcTlsSM2VerifierSdf extends BcTlsVerifier {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BcTlsSM2VerifierSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws TlsFatalAlert {
        try {
            SdfECBaseSigner signer;
            BcTlsCryptoSdf cryptoSdf = (BcTlsCryptoSdf) this.crypto;
            if (cryptoSdf.isUseBC()) {
                signer = new SdfSM2SignerSM3(cryptoSdf.getSdfCryptoType());
            } else {
                signer = new SdfECSigner(cryptoSdf.getSdfCryptoType());
            }
            signer.init(false, publicKey);
            signer.update(hash, 0, hash.length);
            byte[] signature = signedParams.getSignature();
            boolean verified = signer.verifySignature(signature);
            signer.release();
            return verified;
        } catch (SdfSDKException e) {
            throw new TlsFatalAlert(AlertDescription.internal_error, e);
        }
    }
}
