/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_ec_point_formats = Integers.valueOf((int)11);

    public static void addSupportedPointFormatsExtension(Hashtable extensions, short[] ecPointFormats) throws IOException {
        extensions.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(ecPointFormats));
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_ec_point_formats);
        return extensionData == null ? null : TlsECCUtils.readSupportedPointFormatsExtension(extensionData);
    }

    public static byte[] createSupportedPointFormatsExtension(short[] ecPointFormats) throws IOException {
        if (ecPointFormats == null || !Arrays.contains((short[])ecPointFormats, (short)0)) {
            ecPointFormats = Arrays.append((short[])ecPointFormats, (short)0);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(ecPointFormats);
    }

    public static short[] readSupportedPointFormatsExtension(byte[] extensionData) throws IOException {
        short[] ecPointFormats = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (!Arrays.contains((short[])ecPointFormats, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return ecPointFormats;
    }

    public static boolean containsECCipherSuites(int[] cipherSuites) {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!TlsECCUtils.isECCipherSuite(cipherSuites[i])) continue;
            return true;
        }
        return false;
    }

    public static int getMinimumCurveBits(int cipherSuite) {
        return TlsECCUtils.isECCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isECCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    public static short getCompressionFormat(int namedGroup) throws IOException {
        if (NamedGroup.isPrimeCurve(namedGroup)) {
            return 1;
        }
        if (NamedGroup.isChar2Curve(namedGroup)) {
            return 2;
        }
        throw new TlsFatalAlert(47);
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, int namedGroup) throws IOException {
        return TlsECCUtils.isCompressionPreferred(peerECPointFormats, TlsECCUtils.getCompressionFormat(namedGroup));
    }

    public static boolean isCompressionPreferred(short[] peerECPointFormats, short compressionFormat) {
        if (peerECPointFormats == null || compressionFormat == 0) {
            return false;
        }
        for (int i = 0; i < peerECPointFormats.length; ++i) {
            short ecPointFormat = peerECPointFormats[i];
            if (ecPointFormat == 0) {
                return false;
            }
            if (ecPointFormat != compressionFormat) continue;
            return true;
        }
        return false;
    }

    public static void checkPointEncoding(short[] localECPointFormats, int namedGroup, byte[] encoding) throws IOException {
        if (encoding == null || encoding.length < 1) {
            throw new TlsFatalAlert(47);
        }
        short actualFormat = TlsECCUtils.getActualFormat(namedGroup, encoding);
        TlsECCUtils.checkActualFormat(localECPointFormats, actualFormat);
    }

    public static void checkActualFormat(short[] localECPointFormats, short actualFormat) throws IOException {
        if (!(actualFormat == 0 || localECPointFormats != null && Arrays.contains((short[])localECPointFormats, (short)actualFormat))) {
            throw new TlsFatalAlert(47);
        }
    }

    public static short getActualFormat(int namedGroup, byte[] encoding) throws IOException {
        switch (encoding[0]) {
            case 2: 
            case 3: {
                return TlsECCUtils.getCompressionFormat(namedGroup);
            }
            case 4: {
                return 0;
            }
        }
        throw new TlsFatalAlert(47);
    }

    public static TlsECConfig readECConfig(short[] peerECPointFormats, InputStream input) throws IOException {
        short curveType = TlsUtils.readUint8(input);
        if (curveType != 3) {
            throw new TlsFatalAlert(40);
        }
        int namedGroup = TlsUtils.readUint16(input);
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            throw new TlsFatalAlert(47);
        }
        boolean compressed = TlsECCUtils.isCompressionPreferred(peerECPointFormats, namedGroup);
        TlsECConfig result = new TlsECConfig();
        result.setNamedGroup(namedGroup);
        result.setPointCompression(compressed);
        return result;
    }

    public static TlsECConfig receiveECConfig(TlsECConfigVerifier ecConfigVerifier, short[] peerECPointFormats, InputStream input) throws IOException {
        TlsECConfig ecConfig = TlsECCUtils.readECConfig(peerECPointFormats, input);
        if (!ecConfigVerifier.accept(ecConfig)) {
            throw new TlsFatalAlert(47);
        }
        return ecConfig;
    }

    public static void writeECConfig(TlsECConfig ecConfig, OutputStream output) throws IOException {
        TlsECCUtils.writeNamedECParameters(ecConfig.getNamedGroup(), output);
    }

    public static void writeNamedECParameters(int namedGroup, OutputStream output) throws IOException {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, output);
        TlsUtils.checkUint16(namedGroup);
        TlsUtils.writeUint16(namedGroup, output);
    }
}

