/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfSM2SignerSM3;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcTlsSM2VerifierSdf
extends BcTlsVerifier {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BcTlsSM2VerifierSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) throws TlsFatalAlert {
        try {
            BcTlsCryptoSdf cryptoSdf = (BcTlsCryptoSdf)this.crypto;
            Object signer = cryptoSdf.isUseBC() ? new SdfSM2SignerSM3(cryptoSdf.getSdfCryptoType()) : new SdfECSigner(cryptoSdf.getSdfCryptoType());
            signer.init(false, (CipherParameters)this.publicKey);
            signer.update(hash, 0, hash.length);
            byte[] signature = signedParams.getSignature();
            boolean verified = signer.verifySignature(signature);
            signer.release();
            return verified;
        }
        catch (SdfSDKException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

