package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.Constants;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfRandom;
import com.xdja.pki.gmssl.sdf.SdfSDK;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;

/**
 * Basic builder class for constructing standard TlsCrypto classes.
 */
public class BcTlsCryptoProvider implements TlsCryptoProvider {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private GMSSLCryptoType type;

    public BcTlsCryptoProvider() {
        this.type = GMSSLCryptoType.BC;
    }

    public void setType(GMSSLCryptoType type) {
        this.type = type;
    }

    /**
     * Create a new TlsCrypto using the current builder configuration and the passed in entropy source..
     *
     * @param random SecureRandom for generating key material and seeds for nonce generation.
     * @return a new TlsCrypto.
     */
    @Override
    public TlsCrypto create(SecureRandom random) {
        logger.debug("create TlsCrypto type " + this.type);
//        try {
//            if (random == null) {
//                // TODO: 2019/4/3 DEFAULT will be waiting...
//                random = SecureRandom.getInstance("NativePRNGNonBlocking");
//            }
//        } catch (NoSuchAlgorithmException e) {
//            throw new IllegalStateException("unable to create TlsCrypto: " + e.getMessage(), e);
//        }
        if (random == null) {
            // TODO: 2019/4/3 DEFAULT will be waiting...
            random = new SecureRandom();
        }
        switch (this.type) {
            case BC:
                return new BcTlsCrypto(random);
            case XDJA_SDF_PCIE:
                return new BcTlsCryptoSdf(SdfCryptoType.PCIE, random, false);
            case XDJA_SDF_YUNHSM:
                return new BcTlsCryptoSdf(SdfCryptoType.YUNHSM, random, false);
            case SDF_PCIE:
                return new BcTlsCryptoSdf(SdfCryptoType.PCIE, random, true);
            case SDF_YUNHSM:
                return new BcTlsCryptoSdf(SdfCryptoType.YUNHSM, random, true);
            default:
                throw new IllegalStateException("unable to create TlsCrypto: " + this.type, null);
        }
    }

    /**
     * Create a new TlsCrypto using the current builder configuration.
     *
     * @param keyRandom   SecureRandom for generating key material.
     * @param nonceRandom SecureRandom for generating nonces.
     * @return a new TlsCrypto.
     */
    @Override
    public TlsCrypto create(SecureRandom keyRandom, SecureRandom nonceRandom) {
        return create(keyRandom);
    }

    //GMSSL SUPPORT add pki
    public Provider getPkixProvider() {
        return new BouncyCastleProvider();
    }
}
