/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;

public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final Constructor<AlgorithmParameterSpec> specConstructor = JceAEADCipherImpl.initSpecConstructor();
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private SecretKey key;

    private static Constructor<AlgorithmParameterSpec> initSpecConstructor() {
        try {
            Class<AlgorithmParameterSpec> clazz = AccessController.doPrivileged(new PrivilegedAction<Class<AlgorithmParameterSpec>>(){

                @Override
                public Class<AlgorithmParameterSpec> run() {
                    try {
                        return Class.forName("javax.crypto.spec.GCMParameterSpec", true, IvParameterSpec.class.getClassLoader());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            return clazz.getConstructor(Integer.TYPE, byte[].class);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public JceAEADCipherImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] nonce, int macSize, byte[] additionalData) {
        try {
            if (specConstructor != null) {
                try {
                    AlgorithmParameterSpec spec = specConstructor.newInstance(macSize * 8, nonce);
                    this.cipher.init(this.cipherMode, (Key)this.key, spec);
                    if (additionalData != null && additionalData.length > 0) {
                        this.cipher.updateAAD(additionalData);
                    }
                    return;
                }
                catch (GeneralSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(nonce, macSize * 8, additionalData));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getOutputSize(int inputLength) {
        return this.cipher.getOutputSize(inputLength);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            return this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

