package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfECBaseSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfECSigner;
import com.xdja.pki.gmssl.crypto.sdf.SdfEcSignerWithSoftDigest;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;

import java.io.IOException;

/**
 * Operator supporting the generation of RSA signatures using the BC light-weight API.
 */
//GMSSL SUPPORT: 2018/7/31 for ecc sm2 signer
public class BcTlsSM2SignerSdf extends BcTlsSigner {

    protected BcTlsSM2SignerSdf(BcTlsCryptoSdf crypto, AsymmetricKeyParameter privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            SdfECBaseSigner signer;
            BcTlsCryptoSdf cryptoSdf = (BcTlsCryptoSdf) this.crypto;
            if (cryptoSdf.isUseBC()){
                signer = new SdfEcSignerWithSoftDigest(cryptoSdf.getSdfCryptoType());
            } else {
                signer = new SdfECSigner(cryptoSdf.getSdfCryptoType());
            }
            signer.init(true, privateKey);
            signer.update(hash, 0, hash.length);
            byte[] sign = signer.generateSignature();
            signer.release();
            return sign;
        } catch (CryptoException | SdfSDKException e) {
            throw new TlsFatalAlert(AlertDescription.internal_error, e);
        }
    }
}
