/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import com.xdja.pki.gmssl.crypto.sdf.SdfECKeyParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCryptoSdf;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2VerifierSdf;
import org.bouncycastle.util.Arrays;

public class BcTlsCertificateSdf
implements TlsCertificate {
    protected final BcTlsCryptoSdf crypto;
    protected final Certificate certificate;
    protected ECPublicKeyParameters ecPublicKey = null;

    public static BcTlsCertificateSdf convert(BcTlsCryptoSdf crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificateSdf) {
            return (BcTlsCertificateSdf)certificate;
        }
        return new BcTlsCertificateSdf(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            return Certificate.getInstance((Object)encoding);
        }
        catch (IllegalArgumentException e) {
            throw new TlsCryptoException("unable to decode certificate: " + e.getMessage(), e);
        }
    }

    public BcTlsCertificateSdf(BcTlsCryptoSdf crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificateSdf.parseCertificate(encoding));
    }

    public BcTlsCertificateSdf(BcTlsCryptoSdf crypto, Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 4: {
                return new BcTlsSM2VerifierSdf(this.crypto, this.getPublicKey());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (publicKey instanceof SdfECKeyParameters) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone((byte[])extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo keyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            PublicKey publicKey = KeyFactory.getInstance("EC", "BC").generatePublic(new X509EncodedKeySpec(keyInfo.getEncoded()));
            return new SdfECKeyParameters((ECPublicKey)publicKey);
        }
        catch (RuntimeException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = this.certificate.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions((Extensions)exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    public X509Certificate getX509Certificate() throws IOException {
        try {
            byte[] derEncoding = this.getEncoded();
            ByteArrayInputStream input = new ByteArrayInputStream(derEncoding);
            X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(input);
            if (input.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return certificate;
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to decode certificate", e);
        }
    }
}

